/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.commandline.AtLeastParameterStrategy;
import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.commandline.ParameterStrategy;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.NodeLoader;
import com.jeantessier.dependency.Printer;
import com.jeantessier.dependency.TextPrinter;
import com.jeantessier.dependency.TransitiveClosure;
import com.jeantessier.dependency.XMLPrinter;
import com.jeantessier.dependencyfinder.cli.Command;
import java.io.PrintStream;
import org.apache.log4j.Logger;

public class DependencyClosure
extends Command {
    public DependencyClosure() throws CommandLineException {
        super("DependencyClosure");
    }

    protected void showSpecificUsage(PrintStream out) {
        out.println();
        out.println("Defaults is text output to the console.");
        out.println();
    }

    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.populateCommandLineSwitchesForXMLOutput("utf-8", "http://depfind.sourceforge.net/dtd");
        this.populateCommandLineSwitchesForStartCondition();
        this.populateCommandLineSwitchesForStopCondition();
        this.getCommandLine().addOptionalValueSwitch("maximum-inbound-depth");
        this.getCommandLine().addOptionalValueSwitch("maximum-outbound-depth");
        this.getCommandLine().addToggleSwitch("xml");
        this.getCommandLine().addToggleSwitch("validate");
    }

    protected ParameterStrategy getParameterStrategy() {
        return new AtLeastParameterStrategy(1);
    }

    protected void doProcessing() throws Exception {
        NodeFactory factory = new NodeFactory();
        for (String filename : this.getCommandLine().getParameters()) {
            if (filename.endsWith(".xml")) {
                this.getVerboseListener().print("Reading " + filename);
                NodeLoader loader = new NodeLoader(factory, this.getCommandLine().getToggleSwitch("validate"));
                loader.addDependencyListener(this.getVerboseListener());
                loader.load(filename);
                this.getVerboseListener().print("Read \"" + filename + "\".");
                continue;
            }
            this.getVerboseListener().print("Skipping \"" + filename + "\".");
        }
        TransitiveClosure selector = new TransitiveClosure(this.getStartCriteria(), this.getStopCriteria());
        try {
            if (this.getCommandLine().isPresent("maximum-inbound-depth")) {
                selector.setMaximumInboundDepth(Long.parseLong(this.getCommandLine().getSingleSwitch("maximum-inbound-depth")));
            }
        }
        catch (NumberFormatException ex) {
            selector.setMaximumInboundDepth(TransitiveClosure.UNBOUNDED_DEPTH);
        }
        try {
            if (this.getCommandLine().isPresent("maximum-outbound-depth")) {
                selector.setMaximumOutboundDepth(Long.parseLong(this.getCommandLine().getSingleSwitch("maximum-outbound-depth")));
            }
        }
        catch (NumberFormatException ex) {
            selector.setMaximumOutboundDepth(TransitiveClosure.UNBOUNDED_DEPTH);
        }
        Logger.getLogger(this.getClass()).info((Object)("Operating on " + factory.getPackages().values().size() + " package(s) ..."));
        selector.traverseNodes(factory.getPackages().values());
        Logger.getLogger(this.getClass()).info((Object)("Reporting " + selector.getFactory().getPackages().values().size() + " package(s) ..."));
        this.getVerboseListener().print("Printing the graph ...");
        Printer printer = this.getCommandLine().isPresent("xml") ? new XMLPrinter(this.out, this.getCommandLine().getSingleSwitch("encoding"), this.getCommandLine().getSingleSwitch("dtd-prefix")) : new TextPrinter(this.out);
        if (this.getCommandLine().isPresent("indent-text")) {
            printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
        }
        printer.traverseNodes(selector.getFactory().getPackages().values());
    }

    public static void main(String[] args) throws Exception {
        new DependencyClosure().run(args);
    }
}

