/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.commandline.CollectingParameterStrategy;
import com.jeantessier.commandline.CommandLine;
import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.commandline.CommandLineUsage;
import com.jeantessier.commandline.ParameterStrategy;
import com.jeantessier.commandline.TextPrinter;
import com.jeantessier.dependency.CollectionSelectionCriteria;
import com.jeantessier.dependency.ComprehensiveSelectionCriteria;
import com.jeantessier.dependency.NullSelectionCriteria;
import com.jeantessier.dependency.RegularExpressionSelectionCriteria;
import com.jeantessier.dependency.SelectionCriteria;
import com.jeantessier.dependencyfinder.Version;
import com.jeantessier.dependencyfinder.cli.VerboseListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Command {
    public static final String DEFAULT_LOGFILE = "System.out";
    public static final String DEFAULT_INCLUDES = "//";
    private String name;
    private CommandLine commandLine;
    private CommandLineUsage commandLineUsage;
    private Date startTime;
    private VerboseListener verboseListener;
    protected PrintWriter out;

    public Command(String name) throws CommandLineException {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private void resetCommandLine() {
        this.commandLine = new CommandLine(this.getParameterStrategy());
        this.populateCommandLineSwitches();
    }

    protected ParameterStrategy getParameterStrategy() {
        return new CollectingParameterStrategy();
    }

    protected CommandLine getCommandLine() {
        if (this.commandLine == null) {
            this.resetCommandLine();
        }
        return this.commandLine;
    }

    public CommandLineUsage getCommandLineUsage() {
        if (this.commandLineUsage == null) {
            this.commandLineUsage = new CommandLineUsage(this.getName());
            this.getCommandLine().accept(this.commandLineUsage);
        }
        return this.commandLineUsage;
    }

    protected VerboseListener getVerboseListener() {
        return this.verboseListener;
    }

    public void run(String[] args) throws Exception {
        if (this.validateCommandLine(args, System.err)) {
            this.process();
        } else {
            System.exit(1);
        }
    }

    protected void populateCommandLineSwitches() {
        this.getCommandLine().addToggleSwitch("echo");
        this.getCommandLine().addToggleSwitch("help");
        this.getCommandLine().addSingleValueSwitch("out");
        this.getCommandLine().addToggleSwitch("time");
        this.getCommandLine().addOptionalValueSwitch("verbose", DEFAULT_LOGFILE);
        this.getCommandLine().addToggleSwitch("version");
    }

    protected void populateCommandLineSwitchesForXMLOutput(String defaultEncoding, String defaultDTDPrefix) {
        this.getCommandLine().addSingleValueSwitch("encoding", defaultEncoding);
        this.getCommandLine().addSingleValueSwitch("dtd-prefix", defaultDTDPrefix);
        this.getCommandLine().addSingleValueSwitch("indent-text");
    }

    protected Collection<CommandLineException> parseCommandLine(String[] args) {
        this.resetCommandLine();
        return this.getCommandLine().parse(args);
    }

    protected boolean validateCommandLine(String[] args, PrintStream out) {
        boolean result = true;
        Collection<CommandLineException> exceptions = this.parseCommandLine(args);
        if (this.getCommandLine().getToggleSwitch("version")) {
            this.showVersion(out);
            result = false;
        }
        if (this.getCommandLine().getToggleSwitch("help")) {
            this.showError(out);
            result = false;
        }
        if (this.getCommandLine().getToggleSwitch("echo")) {
            this.echo(out);
            result = false;
        }
        if (result) {
            for (CommandLineException exception : exceptions) {
                result = false;
                Logger.getLogger(this.getClass()).error((Object)exception);
            }
        }
        return result;
    }

    protected Collection<CommandLineException> validateCommandLineForScoping() {
        ArrayList<CommandLineException> exceptions = new ArrayList<CommandLineException>();
        if (this.hasScopeRegularExpressionSwitches() && this.hasScopeListSwitches()) {
            exceptions.add(new CommandLineException("You can use switches for regular expressions or lists for scope, but not at the same time"));
        }
        return exceptions;
    }

    protected Collection<CommandLineException> validateCommandLineForFiltering() {
        ArrayList<CommandLineException> exceptions = new ArrayList<CommandLineException>();
        if (this.hasFilterRegularExpressionSwitches() && this.hasFilterListSwitches()) {
            exceptions.add(new CommandLineException("You can use switches for regular expressions or lists for filter, but not at the same time"));
        }
        return exceptions;
    }

    private void process() throws Exception {
        this.startProcessing();
        this.doProcessing();
        this.stopProcessing();
    }

    private void startProcessing() throws IOException {
        this.startVerboseListener();
        this.startTimer();
        this.startOutput();
    }

    protected abstract void doProcessing() throws Exception;

    private void stopProcessing() {
        this.stopTimer();
        this.stopOutput();
        this.stopVerboseListener();
    }

    private void startVerboseListener() throws IOException {
        this.verboseListener = new VerboseListener();
        if (this.commandLine.isPresent("verbose")) {
            if (DEFAULT_LOGFILE.equals(this.commandLine.getOptionalSwitch("verbose"))) {
                this.verboseListener.setWriter(new OutputStreamWriter(System.out));
            } else {
                this.verboseListener.setWriter(new FileWriter(this.commandLine.getOptionalSwitch("verbose")));
            }
        }
    }

    private void stopVerboseListener() {
        this.verboseListener.close();
    }

    private void startTimer() {
        this.startTime = new Date();
    }

    private void stopTimer() {
        if (this.commandLine.getToggleSwitch("time")) {
            Date end = new Date();
            System.err.println(this.getClass().getName() + ": " + ((double)end.getTime() - (double)this.startTime.getTime()) / 1000.0 + " secs.");
        }
    }

    private void startOutput() throws IOException {
        this.out = this.getCommandLine().isPresent("out") ? new PrintWriter(new FileWriter(this.getCommandLine().getSingleSwitch("out"))) : new PrintWriter(new OutputStreamWriter(System.out));
    }

    private void stopOutput() {
        this.out.close();
    }

    protected void echo() {
        this.echo(System.err);
    }

    protected void echo(PrintStream out) {
        TextPrinter printer = new TextPrinter(this.getClass().getSimpleName());
        this.getCommandLine().accept(printer);
        out.println(printer);
    }

    protected void showError() {
        this.showError(System.err);
    }

    protected void showError(PrintStream out) {
        out.println(this.getCommandLineUsage());
        this.showSpecificUsage(out);
    }

    protected void showError(String msg) {
        this.showError(System.err, msg);
    }

    protected void showError(PrintStream out, String msg) {
        out.println(msg);
        this.showError(out);
    }

    protected abstract void showSpecificUsage(PrintStream var1);

    protected void showVersion() {
        this.showVersion(System.err);
    }

    protected void showVersion(PrintStream out) {
        Version version = new Version();
        out.print(version.getImplementationTitle());
        out.print(" ");
        out.print(version.getImplementationVersion());
        out.print(" (c) ");
        out.print(version.getCopyrightDate());
        out.print(" ");
        out.print(version.getCopyrightHolder());
        out.println();
        out.print(version.getImplementationURL());
        out.println();
        out.print("Compiled on ");
        out.print(version.getImplementationDate());
        out.println();
    }

    protected void populateCommandLineSwitchesForScoping() {
        this.populateRegularExpressionCommandLineSwitches("scope", true, DEFAULT_INCLUDES);
        this.populateListCommandLineSwitches("scope");
    }

    protected void populateCommandLineSwitchesForFiltering() {
        this.populateRegularExpressionCommandLineSwitches("filter", true, DEFAULT_INCLUDES);
        this.populateListCommandLineSwitches("filter");
    }

    protected void populateCommandLineSwitchesForStartCondition() {
        this.populateRegularExpressionCommandLineSwitches("start", false, DEFAULT_INCLUDES);
        this.populateListCommandLineSwitches("start");
    }

    protected void populateCommandLineSwitchesForStopCondition() {
        this.populateRegularExpressionCommandLineSwitches("stop", false, null);
        this.populateListCommandLineSwitches("stop");
    }

    protected void populateRegularExpressionCommandLineSwitches(String name, boolean addToggles, String defaultIncludes) {
        if (defaultIncludes != null) {
            this.getCommandLine().addMultipleValuesSwitch(name + "-includes", defaultIncludes);
        } else {
            this.getCommandLine().addMultipleValuesSwitch(name + "-includes");
        }
        this.getCommandLine().addMultipleValuesSwitch(name + "-excludes");
        this.getCommandLine().addMultipleValuesSwitch("package-" + name + "-includes");
        this.getCommandLine().addMultipleValuesSwitch("package-" + name + "-excludes");
        this.getCommandLine().addMultipleValuesSwitch("class-" + name + "-includes");
        this.getCommandLine().addMultipleValuesSwitch("class-" + name + "-excludes");
        this.getCommandLine().addMultipleValuesSwitch("feature-" + name + "-includes");
        this.getCommandLine().addMultipleValuesSwitch("feature-" + name + "-excludes");
        if (addToggles) {
            this.getCommandLine().addToggleSwitch("package-" + name);
            this.getCommandLine().addToggleSwitch("class-" + name);
            this.getCommandLine().addToggleSwitch("feature-" + name);
        }
    }

    protected void populateListCommandLineSwitches(String name) {
        this.getCommandLine().addMultipleValuesSwitch(name + "-includes-list");
        this.getCommandLine().addMultipleValuesSwitch(name + "-excludes-list");
    }

    protected SelectionCriteria getScopeCriteria() {
        return this.getSelectionCriteria("scope", new ComprehensiveSelectionCriteria());
    }

    protected SelectionCriteria getFilterCriteria() {
        return this.getSelectionCriteria("filter", new ComprehensiveSelectionCriteria());
    }

    protected SelectionCriteria getStartCriteria() {
        return this.getSelectionCriteria("start", new ComprehensiveSelectionCriteria());
    }

    protected SelectionCriteria getStopCriteria() {
        return this.getSelectionCriteria("stop", new NullSelectionCriteria());
    }

    protected SelectionCriteria getSelectionCriteria(String name, SelectionCriteria defaultSelectionCriteria) {
        SelectionCriteria result = defaultSelectionCriteria;
        if (this.hasRegularExpressionSwitches(name)) {
            RegularExpressionSelectionCriteria regularExpressionFilterCriteria = new RegularExpressionSelectionCriteria();
            if (this.getCommandLine().isPresent("package-" + name) || this.getCommandLine().isPresent("class-" + name) || this.getCommandLine().isPresent("feature-" + name)) {
                regularExpressionFilterCriteria.setMatchingPackages(this.getCommandLine().getToggleSwitch("package-" + name));
                regularExpressionFilterCriteria.setMatchingClasses(this.getCommandLine().getToggleSwitch("class-" + name));
                regularExpressionFilterCriteria.setMatchingFeatures(this.getCommandLine().getToggleSwitch("feature-" + name));
            }
            if (this.getCommandLine().isPresent(name + "-includes") || !this.getCommandLine().isPresent("package-" + name + "-includes") && !this.getCommandLine().isPresent("class-" + name + "-includes") && !this.getCommandLine().isPresent("feature-" + name + "-includes")) {
                regularExpressionFilterCriteria.setGlobalIncludes(this.getCommandLine().getMultipleSwitch(name + "-includes"));
            }
            regularExpressionFilterCriteria.setGlobalExcludes(this.getCommandLine().getMultipleSwitch(name + "-excludes"));
            regularExpressionFilterCriteria.setPackageIncludes(this.getCommandLine().getMultipleSwitch("package-" + name + "-includes"));
            regularExpressionFilterCriteria.setPackageExcludes(this.getCommandLine().getMultipleSwitch("package-" + name + "-excludes"));
            regularExpressionFilterCriteria.setClassIncludes(this.getCommandLine().getMultipleSwitch("class-" + name + "-includes"));
            regularExpressionFilterCriteria.setClassExcludes(this.getCommandLine().getMultipleSwitch("class-" + name + "-excludes"));
            regularExpressionFilterCriteria.setFeatureIncludes(this.getCommandLine().getMultipleSwitch("feature-" + name + "-includes"));
            regularExpressionFilterCriteria.setFeatureExcludes(this.getCommandLine().getMultipleSwitch("feature-" + name + "-excludes"));
            result = regularExpressionFilterCriteria;
        } else if (this.hasListSwitches(name)) {
            result = this.createCollectionSelectionCriteria(this.getCommandLine().getMultipleSwitch(name + "-includes-list"), this.getCommandLine().getMultipleSwitch(name + "-excludes-list"));
        }
        return result;
    }

    protected boolean hasScopeRegularExpressionSwitches() {
        return this.hasRegularExpressionSwitches("scope");
    }

    protected boolean hasFilterRegularExpressionSwitches() {
        return this.hasRegularExpressionSwitches("filter");
    }

    protected boolean hasRegularExpressionSwitches(String name) {
        Set<String> switches = this.getCommandLine().getPresentSwitches();
        return switches.contains(name + "-includes") || switches.contains(name + "-excludes") || switches.contains("package-" + name) || switches.contains("package-" + name + "-includes") || switches.contains("package-" + name + "-excludes") || switches.contains("class-" + name) || switches.contains("class-" + name + "-includes") || switches.contains("class-" + name + "-excludes") || switches.contains("feature-" + name) || switches.contains("feature-" + name + "-includes") || switches.contains("feature-" + name + "-excludes");
    }

    protected boolean hasScopeListSwitches() {
        return this.hasListSwitches("scope");
    }

    protected boolean hasFilterListSwitches() {
        return this.hasListSwitches("filter");
    }

    protected boolean hasListSwitches(String name) {
        Set<String> switches = this.getCommandLine().getPresentSwitches();
        return switches.contains(name + "-includes-list") || switches.contains(name + "-excludes-list");
    }

    protected CollectionSelectionCriteria createCollectionSelectionCriteria(Collection<String> includes, Collection<String> excludes) {
        return new CollectionSelectionCriteria(this.loadCollection(includes), this.loadCollection(excludes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> loadCollection(Collection<String> filenames) {
        HashSet<String> result = null;
        if (!filenames.isEmpty()) {
            result = new HashSet<String>();
            for (String filename : filenames) {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = new BufferedReader(new FileReader(filename));
                    while ((line = reader.readLine()) != null) {
                        result.add(line);
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass()).error((Object)("Couldn't read file " + filename), (Throwable)ex);
                }
                finally {
                    try {
                        if (reader == null) continue;
                        reader.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(this.getClass()).error((Object)("Couldn't close file " + filename), (Throwable)ex);
                    }
                }
            }
        }
        return result;
    }
}

