/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.classreader.AggregatingClassfileLoader;
import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.Printer;
import com.jeantessier.classreader.TextPrinter;
import com.jeantessier.classreader.XMLPrinter;
import com.jeantessier.commandline.AtLeastParameterStrategy;
import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.commandline.ParameterStrategy;
import com.jeantessier.dependencyfinder.cli.Command;
import java.io.PrintStream;
import java.util.List;

public class ClassReader
extends Command {
    public ClassReader() throws CommandLineException {
        super("ClassReader");
    }

    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.populateCommandLineSwitchesForXMLOutput("utf-8", "http://depfind.sourceforge.net/dtd");
        this.getCommandLine().addToggleSwitch("xml");
    }

    protected ParameterStrategy getParameterStrategy() {
        return new AtLeastParameterStrategy(1);
    }

    public void showSpecificUsage(PrintStream out) {
        out.println();
        out.println("If no files are specified, it processes the current directory.");
        out.println();
    }

    protected void doProcessing() throws Exception {
        List<String> parameters = this.getCommandLine().getParameters();
        if (parameters.size() == 0) {
            parameters.add(".");
        }
        AggregatingClassfileLoader loader = new AggregatingClassfileLoader();
        ((ClassfileLoader)loader).addLoadListener(this.getVerboseListener());
        loader.load(parameters);
        Printer printer = this.getCommandLine().getToggleSwitch("xml") ? new XMLPrinter(this.out, this.getCommandLine().getSingleSwitch("encoding"), this.getCommandLine().getSingleSwitch("dtd-prefix")) : new TextPrinter(this.out);
        if (this.getCommandLine().isPresent("indent-text")) {
            printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
        }
        printer.visitClassfiles(((ClassfileLoader)loader).getAllClassfiles());
    }

    public static void main(String[] args) throws Exception {
        new ClassReader().run(args);
    }
}

