/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.Instruction;
import com.jeantessier.classreader.LoadListenerVisitorAdapter;
import com.jeantessier.classreader.MetricsGatherer;
import com.jeantessier.classreader.TransientClassfileLoader;
import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.dependencyfinder.cli.Command;
import com.jeantessier.text.Hex;
import java.io.PrintStream;
import java.util.Collection;
import java.util.List;

public class ClassMetrics
extends Command {
    private boolean list;

    public ClassMetrics() throws CommandLineException {
        super("ClassMetrics");
    }

    protected void showSpecificUsage(PrintStream out) {
        System.err.println();
        System.err.println("If no files are specified, it processes the current directory.");
        System.err.println();
        System.err.println("If file is a directory, it is recusively scanned for files");
        System.err.println("ending in \".class\".");
        System.err.println();
        System.err.println("Defaults is text output to the console.");
        System.err.println();
    }

    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.getCommandLine().addToggleSwitch("list");
        this.getCommandLine().addToggleSwitch("instruction-counts");
    }

    public void doProcessing() throws Exception {
        this.list = this.getCommandLine().getToggleSwitch("list");
        List<String> parameters = this.getCommandLine().getParameters();
        if (parameters.size() == 0) {
            parameters.add(".");
        }
        MetricsGatherer metrics = new MetricsGatherer();
        TransientClassfileLoader loader = new TransientClassfileLoader();
        ((ClassfileLoader)loader).addLoadListener(this.getVerboseListener());
        ((ClassfileLoader)loader).addLoadListener(new LoadListenerVisitorAdapter(metrics));
        loader.load(parameters);
        this.getVerboseListener().print("Printing report ...");
        this.out.println(metrics.getClasses().size() + " class(es)");
        if (this.list) {
            for (Object o : metrics.getClasses()) {
                this.out.println("        " + o);
            }
        }
        this.out.println(metrics.getInterfaces().size() + " interface(s)");
        if (this.list) {
            for (Object o : metrics.getInterfaces()) {
                this.out.println("        " + o);
            }
        }
        this.out.println();
        this.out.println(metrics.getMethods().size() + " method(s) (average " + (double)metrics.getMethods().size() / ((double)metrics.getClasses().size() + (double)metrics.getInterfaces().size()) + " per class/interface)");
        this.out.println(metrics.getFields().size() + " field(s) (average " + (double)metrics.getFields().size() / ((double)metrics.getClasses().size() + (double)metrics.getInterfaces().size()) + " per class/interface)");
        this.out.println();
        this.printCFM(" synthetic element(s)", metrics.getSyntheticClasses(), metrics.getSyntheticFields(), metrics.getSyntheticMethods());
        this.printCFM(" deprecated element(s)", metrics.getDeprecatedClasses(), metrics.getDeprecatedFields(), metrics.getDeprecatedMethods());
        this.printCFMIC(" public element(s)", metrics.getPublicClasses(), metrics.getPublicFields(), metrics.getPublicMethods(), metrics.getPublicInnerClasses());
        this.printFMIC(" protected element(s)", metrics.getProtectedFields(), metrics.getProtectedMethods(), metrics.getProtectedInnerClasses());
        this.printFMIC(" private element(s)", metrics.getPrivateFields(), metrics.getPrivateMethods(), metrics.getPrivateInnerClasses());
        this.printCFMIC(" package element(s)", metrics.getPackageClasses(), metrics.getPackageFields(), metrics.getPackageMethods(), metrics.getPackageInnerClasses());
        this.printCMIC(" abstract element(s)", metrics.getAbstractClasses(), metrics.getAbstractMethods(), metrics.getAbstractInnerClasses());
        this.printFMIC(" static element(s)", metrics.getStaticFields(), metrics.getStaticMethods(), metrics.getStaticInnerClasses());
        this.printCFMIC(" final element(s)", metrics.getFinalClasses(), metrics.getFinalFields(), metrics.getFinalMethods(), metrics.getFinalInnerClasses());
        this.out.println(metrics.getSynchronizedMethods().size() + " synchronized method(s)");
        if (this.list) {
            for (Object o : metrics.getSynchronizedMethods()) {
                this.out.println("        " + o);
            }
        }
        this.out.println(metrics.getNativeMethods().size() + " native method(s)");
        if (this.list) {
            for (Object o : metrics.getNativeMethods()) {
                this.out.println("        " + o);
            }
        }
        this.out.println(metrics.getVolatileFields().size() + " volatile field(s)");
        if (this.list) {
            for (Object o : metrics.getVolatileFields()) {
                this.out.println("        " + o);
            }
        }
        this.out.println(metrics.getTransientFields().size() + " transient field(s)");
        if (this.list) {
            for (Object o : metrics.getTransientFields()) {
                this.out.println("        " + o);
            }
        }
        this.out.println(metrics.getCustomAttributes().size() + " custom attribute(s)");
        if (this.list) {
            for (Object o : metrics.getCustomAttributes()) {
                this.out.println("        " + o);
            }
        }
        if (this.getCommandLine().getToggleSwitch("instruction-counts")) {
            this.out.println();
            this.out.println("Instruction counts:");
            for (int opcode = 0; opcode < 256; ++opcode) {
                this.out.print("        0x");
                Hex.print(this.out, (byte)opcode);
                this.out.println(" " + Instruction.getMnemonic(opcode) + ": " + metrics.getInstructionCounts()[opcode]);
            }
        }
    }

    private void printCMIC(String label, Collection classes, Collection methods, Collection innerClasses) {
        this.out.println(classes.size() + methods.size() + innerClasses.size() + label);
        if (this.list) {
            this.out.println("    " + classes.size() + " class(es)");
            for (Object aClass : classes) {
                this.out.println("        " + aClass);
            }
            this.out.println("    " + methods.size() + " method(s)");
            for (Object method : methods) {
                this.out.println("        " + method);
            }
            this.out.println("    " + innerClasses.size() + " inner class(es)");
            for (Object innerClass : innerClasses) {
                this.out.println("        " + innerClass);
            }
        } else {
            this.out.println("    " + classes.size() + " class(es)");
            this.out.println("    " + methods.size() + " method(s)");
            this.out.println("    " + innerClasses.size() + " inner class(es)");
        }
    }

    private void printCFMIC(String label, Collection classes, Collection fields, Collection methods, Collection innerClasses) {
        this.out.println(classes.size() + fields.size() + methods.size() + innerClasses.size() + label);
        if (this.list) {
            this.out.println("    " + classes.size() + " class(es)");
            for (Object aClass : classes) {
                this.out.println("        " + aClass);
            }
            this.out.println("    " + fields.size() + " field(s)");
            for (Object field : fields) {
                this.out.println("        " + field);
            }
            this.out.println("    " + methods.size() + " method(s)");
            for (Object method : methods) {
                this.out.println("        " + method);
            }
            this.out.println("    " + innerClasses.size() + " inner class(es)");
            for (Object innerClass : innerClasses) {
                this.out.println("        " + innerClass);
            }
        } else {
            this.out.println("    " + classes.size() + " class(es)");
            this.out.println("    " + fields.size() + " fields(s)");
            this.out.println("    " + methods.size() + " method(s)");
            this.out.println("    " + innerClasses.size() + " inner class(es)");
        }
    }

    private void printCFM(String label, Collection classes, Collection fields, Collection methods) {
        this.out.println(classes.size() + fields.size() + methods.size() + label);
        if (this.list) {
            this.out.println("    " + classes.size() + " class(es)");
            for (Object aClass : classes) {
                this.out.println("        " + aClass);
            }
            this.out.println("    " + fields.size() + " field(s)");
            for (Object field : fields) {
                this.out.println("        " + field);
            }
            this.out.println("    " + methods.size() + " method(s)");
            for (Object method : methods) {
                this.out.println("        " + method);
            }
        } else {
            this.out.println("    " + classes.size() + " class(es)");
            this.out.println("    " + fields.size() + " fields(s)");
            this.out.println("    " + methods.size() + " method(s)");
        }
    }

    private void printFMIC(String label, Collection fields, Collection methods, Collection innerClasses) {
        this.out.println(fields.size() + methods.size() + innerClasses.size() + label);
        if (this.list) {
            this.out.println("    " + fields.size() + " field(s)");
            for (Object field : fields) {
                this.out.println("        " + field);
            }
            this.out.println("    " + methods.size() + " method(s)");
            for (Object method : methods) {
                this.out.println("        " + method);
            }
            this.out.println("    " + innerClasses.size() + " inner class(es)");
            for (Object innerClass : innerClasses) {
                this.out.println("        " + innerClass);
            }
        } else {
            this.out.println("    " + fields.size() + " fields(s)");
            this.out.println("    " + methods.size() + " method(s)");
            this.out.println("    " + innerClasses.size() + " inner class(es)");
        }
    }

    public static void main(String[] args) throws Exception {
        new ClassMetrics().run(args);
    }
}

