/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.TransientClassfileLoader;
import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.dependencyfinder.cli.ClassMatcher;
import com.jeantessier.dependencyfinder.cli.Command;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClassFinder
extends Command {
    public ClassFinder() throws CommandLineException {
        super("ClassFinder");
    }

    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.getCommandLine().addMultipleValuesSwitch("includes", "//");
        this.getCommandLine().addMultipleValuesSwitch("excludes");
    }

    public void showSpecificUsage(PrintStream out) {
        out.println();
        out.println("If no files are specified, it processes the current directory.");
        out.println();
    }

    public void doProcessing() throws Exception {
        List<String> parameters = this.getCommandLine().getParameters();
        if (parameters.size() == 0) {
            parameters.add(".");
        }
        ClassMatcher matcher = new ClassMatcher(this.getCommandLine().getMultipleSwitch("includes"), this.getCommandLine().getMultipleSwitch("excludes"));
        TransientClassfileLoader loader = new TransientClassfileLoader();
        ((ClassfileLoader)loader).addLoadListener(matcher);
        ((ClassfileLoader)loader).addLoadListener(this.getVerboseListener());
        loader.load(parameters);
        for (Map.Entry<String, List<String>> entry : matcher.getResults().entrySet()) {
            this.out.print(entry.getKey());
            this.out.print(": ");
            Iterator<String> i = entry.getValue().iterator();
            while (i.hasNext()) {
                this.out.print((Object)i.next());
                if (!i.hasNext()) continue;
                this.out.print(", ");
            }
            this.out.println();
        }
    }

    public static void main(String[] args) throws Exception {
        new ClassFinder().run(args);
    }
}

