/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.classreader.AggregatingClassfileLoader;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.dependencyfinder.cli.DiffCommand;
import com.jeantessier.diff.DifferenceStrategy;
import com.jeantessier.diff.Differences;
import com.jeantessier.diff.DifferencesFactory;
import com.jeantessier.diff.ListBasedDifferenceStrategy;
import com.jeantessier.diff.Report;
import org.apache.log4j.Logger;

public class ClassClassDiff
extends DiffCommand {
    public ClassClassDiff() throws CommandLineException {
        super("ClassClassDiff");
    }

    public void doProcessing() throws Exception {
        AggregatingClassfileLoader oldJar = new AggregatingClassfileLoader();
        ((ClassfileLoader)oldJar).addLoadListener(this.getVerboseListener());
        oldJar.load(this.getCommandLine().getMultipleSwitch("old"));
        AggregatingClassfileLoader newJar = new AggregatingClassfileLoader();
        ((ClassfileLoader)newJar).addLoadListener(this.getVerboseListener());
        newJar.load(this.getCommandLine().getMultipleSwitch("new"));
        DifferenceStrategy baseStrategy = this.getBaseStrategy(this.getCommandLine().getToggleSwitch("code"));
        DifferenceStrategy strategy = this.getStrategy(this.getCommandLine().getSingleSwitch("level"), baseStrategy);
        if (this.getCommandLine().isPresent("filter")) {
            strategy = new ListBasedDifferenceStrategy(strategy, this.getCommandLine().getSingleSwitch("filter"));
        }
        Logger.getLogger(this.getClass()).info((Object)"Comparing ...");
        this.getVerboseListener().print("Comparing ...");
        String name = this.getCommandLine().getSingleSwitch("name");
        String oldLabel = this.getCommandLine().isPresent("old-label") ? this.getCommandLine().getSingleSwitch("old-label") : this.getCommandLine().getMultipleSwitch("old").toString();
        String newLabel = this.getCommandLine().isPresent("new-label") ? this.getCommandLine().getSingleSwitch("new-label") : this.getCommandLine().getMultipleSwitch("new").toString();
        Classfile oldClass = ((ClassfileLoader)oldJar).getAllClassfiles().iterator().next();
        Classfile newClass = ((ClassfileLoader)newJar).getAllClassfiles().iterator().next();
        DifferencesFactory factory = new DifferencesFactory(strategy);
        Differences differences = factory.createClassDifferences(name, oldClass, newClass);
        Logger.getLogger(this.getClass()).info((Object)"Printing results ...");
        this.getVerboseListener().print("Printing results ...");
        Report report = new Report(this.getCommandLine().getSingleSwitch("encoding"), this.getCommandLine().getSingleSwitch("dtd-prefix"));
        if (this.getCommandLine().isPresent("indent-text")) {
            report.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
        }
        report.setName(name);
        report.setOldVersion(oldLabel);
        report.setNewVersion(newLabel);
        differences.accept(report);
        this.out.print(report);
    }

    public static void main(String[] args) throws Exception {
        new ClassClassDiff().run(args);
    }
}

