/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.ant;

import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.LoadListenerVisitorAdapter;
import com.jeantessier.classreader.SymbolGatherer;
import com.jeantessier.classreader.TransientClassfileLoader;
import com.jeantessier.dependencyfinder.ant.VerboseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class ListSymbols
extends Task {
    private boolean classNames = false;
    private boolean fieldNames = false;
    private boolean methodNames = false;
    private boolean localNames = false;
    private File destfile;
    private Path path;

    public boolean getClassnames() {
        return this.classNames;
    }

    public void setClassnames(boolean classNames) {
        this.classNames = classNames;
    }

    public boolean getFieldnames() {
        return this.fieldNames;
    }

    public void setFieldnames(boolean fieldNames) {
        this.fieldNames = fieldNames;
    }

    public boolean getMethodnames() {
        return this.methodNames;
    }

    public void setMethodnames(boolean methodNames) {
        this.methodNames = methodNames;
    }

    public boolean getLocalnames() {
        return this.localNames;
    }

    public void setLocalnames(boolean localNames) {
        this.localNames = localNames;
    }

    public File getDestfile() {
        return this.destfile;
    }

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public Path createPath() {
        if (this.path == null) {
            this.path = new Path(this.getProject());
        }
        return this.path;
    }

    public Path getPath() {
        return this.path;
    }

    public void execute() throws BuildException {
        if (this.getPath() == null) {
            throw new BuildException("path must be set!");
        }
        if (this.getDestfile() == null) {
            throw new BuildException("destfile must be set!");
        }
        this.log("Reading classes from path " + this.getPath());
        VerboseListener verboseListener = new VerboseListener(this);
        SymbolGatherer collector = new SymbolGatherer();
        if (this.getClassnames() || this.getFieldnames() || this.getMethodnames() || this.getLocalnames()) {
            collector.setCollectingClassNames(false);
            collector.setCollectingFieldNames(false);
            collector.setCollectingMethodNames(false);
            collector.setCollectingLocalNames(false);
        }
        if (this.getClassnames()) {
            collector.setCollectingClassNames(true);
        }
        if (this.getFieldnames()) {
            collector.setCollectingFieldNames(true);
        }
        if (this.getMethodnames()) {
            collector.setCollectingMethodNames(true);
        }
        if (this.getLocalnames()) {
            collector.setCollectingLocalNames(true);
        }
        TransientClassfileLoader loader = new TransientClassfileLoader();
        ((ClassfileLoader)loader).addLoadListener(new LoadListenerVisitorAdapter(collector));
        ((ClassfileLoader)loader).addLoadListener(verboseListener);
        loader.load(Arrays.asList(this.getPath().list()));
        this.log("Saving symbols to " + this.getDestfile().getAbsolutePath());
        try {
            PrintWriter out = new PrintWriter(new FileWriter(this.getDestfile()));
            for (String symbol : collector.getCollection()) {
                out.println(symbol);
            }
            out.close();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }
}

