/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.ant;

import com.jeantessier.diff.ListDiffPrinter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.TreeSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ListDiff
extends Task {
    private String name = "";
    private File oldFile;
    private String oldLabel;
    private File newFile;
    private String newLabel;
    private boolean compress = false;
    private String encoding = "utf-8";
    private String dtdPrefix = "http://depfind.sourceforge.net/dtd";
    private String indentText;
    private File destfile;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getOld() {
        return this.oldFile;
    }

    public void setOld(File oldFile) {
        this.oldFile = oldFile;
    }

    public String getOldlabel() {
        return this.oldLabel;
    }

    public void setOldlabel(String oldLabel) {
        this.oldLabel = oldLabel;
    }

    public File getNew() {
        return this.newFile;
    }

    public void setNew(File newFile) {
        this.newFile = newFile;
    }

    public String getNewlabel() {
        return this.newLabel;
    }

    public void setNewlabel(String newLabel) {
        this.newLabel = newLabel;
    }

    public boolean getCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDtdprefix() {
        return this.dtdPrefix;
    }

    public void setDtdprefix(String dtdPrefix) {
        this.dtdPrefix = dtdPrefix;
    }

    public String getIndenttext() {
        return this.indentText;
    }

    public void setIntenttext(String indentText) {
        this.indentText = indentText;
    }

    public File getDestfile() {
        return this.destfile;
    }

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public void execute() throws BuildException {
        if (this.getOld() == null) {
            throw new BuildException("old must be set!");
        }
        if (!this.getOld().exists()) {
            throw new BuildException("old does not exist!");
        }
        if (!this.getOld().isFile()) {
            throw new BuildException("old is not a file!");
        }
        if (this.getNew() == null) {
            throw new BuildException("new must be set!");
        }
        if (!this.getNew().exists()) {
            throw new BuildException("new does not exist!");
        }
        if (!this.getNew().isFile()) {
            throw new BuildException("new is not a file!");
        }
        if (this.getDestfile() == null) {
            throw new BuildException("destfile must be set!");
        }
        try {
            String line;
            this.log("Loading old list from " + this.getOld().getAbsolutePath());
            TreeSet<String> oldAPI = new TreeSet<String>();
            BufferedReader oldIn = new BufferedReader(new FileReader(this.getOld()));
            while ((line = oldIn.readLine()) != null) {
                oldAPI.add(line);
            }
            oldIn.close();
            this.log("Loading new list from " + this.getNew().getAbsolutePath());
            TreeSet<String> newAPI = new TreeSet<String>();
            BufferedReader newIn = new BufferedReader(new FileReader(this.getNew()));
            while ((line = newIn.readLine()) != null) {
                newAPI.add(line);
            }
            newIn.close();
            this.log("Comparing old and new lists ...");
            ListDiffPrinter printer = new ListDiffPrinter(this.getCompress(), this.getEncoding(), this.getDtdprefix());
            printer.setName(this.getName());
            printer.setOldVersion(this.getOldlabel());
            printer.setNewVersion(this.getNewlabel());
            if (this.getIndenttext() != null) {
                printer.setIndentText(this.getIndenttext());
            }
            for (String name : oldAPI) {
                if (newAPI.contains(name)) continue;
                printer.remove(name);
            }
            for (String name : newAPI) {
                if (oldAPI.contains(name)) continue;
                printer.add(name);
            }
            this.log("Saving difference report to " + this.getDestfile().getAbsolutePath());
            PrintWriter out = new PrintWriter(new FileWriter(this.getDestfile()));
            out.print(printer);
            out.close();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }
}

