/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.ant;

import com.jeantessier.dependency.CollectionSelectionCriteria;
import com.jeantessier.dependency.ComprehensiveSelectionCriteria;
import com.jeantessier.dependency.GraphCopier;
import com.jeantessier.dependency.GraphSummarizer;
import com.jeantessier.dependency.LinkMaximizer;
import com.jeantessier.dependency.LinkMinimizer;
import com.jeantessier.dependency.NodeLoader;
import com.jeantessier.dependency.Printer;
import com.jeantessier.dependency.RegularExpressionSelectionCriteria;
import com.jeantessier.dependency.SelectionCriteria;
import com.jeantessier.dependency.SelectiveTraversalStrategy;
import com.jeantessier.dependency.TextPrinter;
import com.jeantessier.dependency.TraversalStrategy;
import com.jeantessier.dependency.XMLPrinter;
import com.jeantessier.dependencyfinder.ant.GraphTask;
import com.jeantessier.dependencyfinder.ant.VerboseListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyReporter
extends GraphTask {
    private String scopeIncludes = "//";
    private String scopeExcludes = "";
    private boolean packageScope = false;
    private String packageScopeIncludes = "";
    private String packageScopeExcludes = "";
    private boolean classScope = false;
    private String classScopeIncludes = "";
    private String classScopeExcludes = "";
    private boolean featureScope = false;
    private String featureScopeIncludes = "";
    private String featureScopeExcludes = "";
    private String filterIncludes = "//";
    private String filterExcludes = "";
    private boolean packageFilter = false;
    private String packageFilterIncludes = "";
    private String packageFilterExcludes = "";
    private boolean classFilter = false;
    private String classFilterIncludes = "";
    private String classFilterExcludes = "";
    private boolean featureFilter = false;
    private String featureFilterIncludes = "";
    private String featureFilterExcludes = "";
    private Path scopeIncludesList;
    private Path scopeExcludesList;
    private Path filterIncludesList;
    private Path filterExcludesList;
    private boolean showInbounds = false;
    private boolean showOutbounds = false;
    private boolean showEmptyNodes = false;
    private boolean minimize = false;
    private boolean maximize = false;
    private boolean copyOnly = false;
    private boolean xml = false;
    private String encoding = "utf-8";
    private String dtdPrefix = "http://depfind.sourceforge.net/dtd";
    private String indentText;

    public String getScopeincludes() {
        return this.scopeIncludes;
    }

    public void setScopeincludes(String scopeIncludes) {
        this.scopeIncludes = scopeIncludes;
    }

    public String getScopeexcludes() {
        return this.scopeExcludes;
    }

    public void setScopeexcludes(String scopeExcludes) {
        this.scopeExcludes = scopeExcludes;
    }

    public boolean getPackagescope() {
        return this.packageScope;
    }

    public void setPackagescope(boolean packageScope) {
        this.packageScope = packageScope;
    }

    public String getPackagescopeincludes() {
        return this.packageScopeIncludes;
    }

    public void setPackagescopeincludes(String packageScopeIncludes) {
        this.packageScopeIncludes = packageScopeIncludes;
    }

    public String getPackagescopeexcludes() {
        return this.packageScopeExcludes;
    }

    public void setPackagescopeexcludes(String packageScopeExcludes) {
        this.packageScopeExcludes = packageScopeExcludes;
    }

    public boolean getClassscope() {
        return this.classScope;
    }

    public void setClassscope(boolean classScope) {
        this.classScope = classScope;
    }

    public String getClassscopeincludes() {
        return this.classScopeIncludes;
    }

    public void setClassscopeincludes(String classScopeIncludes) {
        this.classScopeIncludes = classScopeIncludes;
    }

    public String getClassscopeexcludes() {
        return this.classScopeExcludes;
    }

    public void setClassscopeexcludes(String classScopeExcludes) {
        this.classScopeExcludes = classScopeExcludes;
    }

    public boolean getFeaturescope() {
        return this.featureScope;
    }

    public void setFeaturescope(boolean featureScope) {
        this.featureScope = featureScope;
    }

    public String getFeaturescopeincludes() {
        return this.featureScopeIncludes;
    }

    public void setFeaturescopeincludes(String featureScopeIncludes) {
        this.featureScopeIncludes = featureScopeIncludes;
    }

    public String getFeaturescopeexcludes() {
        return this.featureScopeExcludes;
    }

    public void setFeaturescopeexcludes(String featureScopeExcludes) {
        this.featureScopeExcludes = featureScopeExcludes;
    }

    public String getFilterincludes() {
        return this.filterIncludes;
    }

    public void setFilterincludes(String filterIncludes) {
        this.filterIncludes = filterIncludes;
    }

    public String getFilterexcludes() {
        return this.filterExcludes;
    }

    public void setFilterexcludes(String filterExcludes) {
        this.filterExcludes = filterExcludes;
    }

    public boolean getPackagefilter() {
        return this.packageFilter;
    }

    public void setPackagefilter(boolean packageFilter) {
        this.packageFilter = packageFilter;
    }

    public String getPackagefilterincludes() {
        return this.packageFilterIncludes;
    }

    public void setPackagefilterincludes(String packageFilterIncludes) {
        this.packageFilterIncludes = packageFilterIncludes;
    }

    public String getPackagefilterexcludes() {
        return this.packageFilterExcludes;
    }

    public void setPackagefilterexcludes(String packageFilterExcludes) {
        this.packageFilterExcludes = packageFilterExcludes;
    }

    public boolean getClassfilter() {
        return this.classFilter;
    }

    public void setClassfilter(boolean classFilter) {
        this.classFilter = classFilter;
    }

    public String getClassfilterincludes() {
        return this.classFilterIncludes;
    }

    public void setClassfilterincludes(String classFilterIncludes) {
        this.classFilterIncludes = classFilterIncludes;
    }

    public String getClassfilterexcludes() {
        return this.classFilterExcludes;
    }

    public void setClassfilterexcludes(String classFilterExcludes) {
        this.classFilterExcludes = classFilterExcludes;
    }

    public boolean getFeaturefilter() {
        return this.featureFilter;
    }

    public void setFeaturefilter(boolean featureFilter) {
        this.featureFilter = featureFilter;
    }

    public String getFeaturefilterincludes() {
        return this.featureFilterIncludes;
    }

    public void setFeaturefilterincludes(String featureFilterIncludes) {
        this.featureFilterIncludes = featureFilterIncludes;
    }

    public String getFeaturefilterexcludes() {
        return this.featureFilterExcludes;
    }

    public void setFeaturefilterexcludes(String featureFilterExcludes) {
        this.featureFilterExcludes = featureFilterExcludes;
    }

    public void setP2p(boolean value) {
        this.setPackagescope(value);
        this.setPackagefilter(value);
    }

    public void setC2p(boolean value) {
        this.setClassscope(value);
        this.setPackagefilter(value);
    }

    public void setC2c(boolean value) {
        this.setClassscope(value);
        this.setClassfilter(value);
    }

    public void setF2f(boolean value) {
        this.setFeaturescope(value);
        this.setFeaturefilter(value);
    }

    public void setIncludes(String value) {
        this.setScopeincludes(value);
        this.setFilterincludes(value);
    }

    public void setExcludes(String value) {
        this.setScopeexcludes(value);
        this.setFilterexcludes(value);
    }

    public Path createScopeincludeslist() {
        if (this.scopeIncludesList == null) {
            this.scopeIncludesList = new Path(this.getProject());
        }
        return this.scopeIncludesList;
    }

    public Path getScopeincludeslist() {
        return this.scopeIncludesList;
    }

    public Path createScopeexcludeslist() {
        if (this.scopeExcludesList == null) {
            this.scopeExcludesList = new Path(this.getProject());
        }
        return this.scopeExcludesList;
    }

    public Path getScopeexcludeslist() {
        return this.scopeExcludesList;
    }

    public Path createFilterincludeslist() {
        if (this.filterIncludesList == null) {
            this.filterIncludesList = new Path(this.getProject());
        }
        return this.filterIncludesList;
    }

    public Path getFilterincludeslist() {
        return this.filterIncludesList;
    }

    public Path createFilterexcludeslist() {
        if (this.filterExcludesList == null) {
            this.filterExcludesList = new Path(this.getProject());
        }
        return this.filterExcludesList;
    }

    public Path getFilterexcludeslist() {
        return this.filterExcludesList;
    }

    public boolean getShowinbounds() {
        return this.showInbounds;
    }

    public void setShowinbounds(boolean showInbounds) {
        this.showInbounds = showInbounds;
    }

    public boolean getShowoutbounds() {
        return this.showOutbounds;
    }

    public void setShowoutbounds(boolean showOutbounds) {
        this.showOutbounds = showOutbounds;
    }

    public boolean getShowemptynodes() {
        return this.showEmptyNodes;
    }

    public void setShowemptynodes(boolean showEmptyNodes) {
        this.showEmptyNodes = showEmptyNodes;
    }

    public void setShowAll(boolean showAll) {
        this.setShowinbounds(showAll);
        this.setShowoutbounds(showAll);
        this.setShowemptynodes(showAll);
    }

    public boolean getMinimize() {
        return this.minimize;
    }

    public void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    public boolean getMaximize() {
        return this.maximize;
    }

    public void setMaximize(boolean maximize) {
        this.maximize = maximize;
    }

    public boolean getCopyOnly() {
        return this.copyOnly;
    }

    public void setCopyOnly(boolean copyOnly) {
        this.copyOnly = copyOnly;
    }

    public boolean getXml() {
        return this.xml;
    }

    public void setXml(boolean xml) {
        this.xml = xml;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDtdprefix() {
        return this.dtdPrefix;
    }

    public void setDtdprefix(String dtdPrefix) {
        this.dtdPrefix = dtdPrefix;
    }

    public String getIndenttext() {
        return this.indentText;
    }

    public void setIntenttext(String indentText) {
        this.indentText = indentText;
    }

    @Override
    protected void validateParameters() throws BuildException {
        super.validateParameters();
        if (this.hasScopeRegularExpressionSwitches() && this.hasScopeListSwitches()) {
            throw new BuildException("Cannot have scope attributes for regular expressions and lists at the same time!");
        }
        if (this.hasFilterRegularExpressionSwitches() && this.hasFilterListSwitches()) {
            throw new BuildException("Cannot have filter attributes for regular expressions and lists at the same time!");
        }
    }

    public void execute() throws BuildException {
        this.validateParameters();
        VerboseListener verboseListener = new VerboseListener(this);
        try {
            GraphCopier copier = this.getCopyOnly() || this.getMaximize() ? new GraphCopier(this.getStrategy()) : new GraphSummarizer(this.getScopeCriteria(), this.getFilterCriteria());
            for (String filename : this.getSrc().list()) {
                this.log("Reading graph from " + filename);
                Collection<Object> packages = Collections.emptyList();
                if (filename.endsWith(".xml")) {
                    NodeLoader loader = new NodeLoader(this.getValidate());
                    loader.addDependencyListener(verboseListener);
                    packages = loader.load(filename).getPackages().values();
                }
                if (this.getMaximize()) {
                    this.log("Maximizing ...");
                    new LinkMaximizer().traverseNodes(packages);
                } else if (this.getMinimize()) {
                    this.log("Minimizing ...");
                    new LinkMinimizer().traverseNodes(packages);
                }
                copier.traverseNodes(packages);
            }
            this.log("Saving dependency graph to " + this.getDestfile().getAbsolutePath());
            PrintWriter out = new PrintWriter(new FileWriter(this.getDestfile()));
            Printer printer = this.getXml() ? new XMLPrinter(out, this.getEncoding(), this.getDtdprefix()) : new TextPrinter(out);
            if (this.getIndenttext() != null) {
                printer.setIndentText(this.getIndenttext());
            }
            if (this.getShowinbounds() || this.getShowoutbounds() || this.getShowemptynodes()) {
                printer.setShowInbounds(this.getShowinbounds());
                printer.setShowOutbounds(this.getShowoutbounds());
                printer.setShowEmptyNodes(this.getShowemptynodes());
            }
            printer.traverseNodes(copier.getScopeFactory().getPackages().values());
            out.close();
        }
        catch (SAXException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (ParserConfigurationException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    protected SelectionCriteria getScopeCriteria() throws BuildException {
        SelectionCriteria result = new ComprehensiveSelectionCriteria();
        if (this.hasScopeRegularExpressionSwitches()) {
            result = this.createRegularExpressionScopeCriteria();
        } else if (this.hasScopeListSwitches()) {
            result = this.createCollectionSelectionCriteria(this.getScopeincludeslist(), this.getScopeexcludeslist());
        }
        return result;
    }

    protected SelectionCriteria getFilterCriteria() throws BuildException {
        SelectionCriteria result = new ComprehensiveSelectionCriteria();
        if (this.hasFilterRegularExpressionSwitches()) {
            result = this.createRegularExpressionFilterCriteria();
        } else if (this.hasFilterListSwitches()) {
            result = this.createCollectionSelectionCriteria(this.getFilterincludeslist(), this.getFilterexcludeslist());
        }
        return result;
    }

    protected RegularExpressionSelectionCriteria createRegularExpressionScopeCriteria() throws BuildException {
        RegularExpressionSelectionCriteria result = new RegularExpressionSelectionCriteria();
        if (this.getPackagescope() || this.getClassscope() || this.getFeaturescope()) {
            result.setMatchingPackages(this.getPackagescope());
            result.setMatchingClasses(this.getClassscope());
            result.setMatchingFeatures(this.getFeaturescope());
        }
        result.setGlobalIncludes(this.getScopeincludes());
        result.setGlobalExcludes(this.getScopeexcludes());
        result.setPackageIncludes(this.getPackagescopeincludes());
        result.setPackageExcludes(this.getPackagescopeexcludes());
        result.setClassIncludes(this.getClassscopeincludes());
        result.setClassExcludes(this.getClassscopeexcludes());
        result.setFeatureIncludes(this.getFeaturescopeincludes());
        result.setFeatureExcludes(this.getFeaturescopeexcludes());
        return result;
    }

    protected RegularExpressionSelectionCriteria createRegularExpressionFilterCriteria() throws BuildException {
        RegularExpressionSelectionCriteria result = new RegularExpressionSelectionCriteria();
        if (this.getPackagefilter() || this.getClassfilter() || this.getFeaturefilter()) {
            result.setMatchingPackages(this.getPackagefilter());
            result.setMatchingClasses(this.getClassfilter());
            result.setMatchingFeatures(this.getFeaturefilter());
        }
        result.setGlobalIncludes(this.getFilterincludes());
        result.setGlobalExcludes(this.getFilterexcludes());
        result.setPackageIncludes(this.getPackagefilterincludes());
        result.setPackageExcludes(this.getPackagefilterexcludes());
        result.setClassIncludes(this.getClassfilterincludes());
        result.setClassExcludes(this.getClassfilterexcludes());
        result.setFeatureIncludes(this.getFeaturefilterincludes());
        result.setFeatureExcludes(this.getFeaturefilterexcludes());
        return result;
    }

    private boolean hasScopeRegularExpressionSwitches() {
        return !this.getScopeincludes().equals("//") || !this.getScopeexcludes().equals("") || this.getPackagescope() || !this.getPackagescopeincludes().equals("") || !this.getPackagescopeexcludes().equals("") || this.getClassscope() || !this.getClassscopeincludes().equals("") || !this.getClassscopeexcludes().equals("") || this.getFeaturescope() || !this.getFeaturescopeincludes().equals("") || !this.getFeaturescopeexcludes().equals("");
    }

    private boolean hasScopeListSwitches() {
        return this.getScopeincludeslist() != null || this.getScopeexcludeslist() != null;
    }

    private boolean hasFilterRegularExpressionSwitches() {
        return !this.getFilterincludes().equals("//") || !this.getFilterexcludes().equals("") || this.getPackagefilter() || !this.getPackagefilterincludes().equals("") || !this.getPackagefilterexcludes().equals("") || this.getClassfilter() || !this.getClassfilterincludes().equals("") || !this.getClassfilterexcludes().equals("") || this.getFeaturefilter() || !this.getFeaturefilterincludes().equals("") || !this.getFeaturefilterexcludes().equals("");
    }

    private boolean hasFilterListSwitches() {
        return this.getFilterincludeslist() != null || this.getFilterexcludeslist() != null;
    }

    private CollectionSelectionCriteria createCollectionSelectionCriteria(Path includes, Path excludes) {
        return new CollectionSelectionCriteria(this.loadCollection(includes), this.loadCollection(excludes));
    }

    private TraversalStrategy getStrategy() throws BuildException {
        return new SelectiveTraversalStrategy(this.getScopeCriteria(), this.getFilterCriteria());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> loadCollection(Path path) {
        HashSet<String> result = null;
        if (path != null) {
            result = new HashSet<String>();
            for (String filename : path.list()) {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = new BufferedReader(new FileReader(filename));
                    while ((line = reader.readLine()) != null) {
                        result.add(line);
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)("Couldn't read file " + filename), (Throwable)ex);
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)("Couldn't close file " + filename), (Throwable)ex);
                    }
                }
            }
        }
        return result;
    }
}

