/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder;

import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;

public class Version {
    public static final String DEFAULT_URL = "http://depfind.sourceforge.net/";
    public static final String DEFAULT_TITLE = "Dependency Finder";
    public static final String DEFAULT_VERSION = "<i>unknown</i>";
    public static final String DEFAULT_VENDOR = "Jean Tessier";
    public static final String DEFAULT_DATE = "<i>unknown</i>";
    public static final String DEFAULT_COPYRIGHT_HOLDER = "Jean Tessier";
    public static final String DEFAULT_COPYRIGHT_DATE = "2001-2007";
    private String resourceURL = this.getClass().getResource("Version.class").toString();
    private String jarName = null;
    private Attributes attributes = null;

    public Version() {
        if (this.resourceURL.startsWith("jar:file:")) {
            this.jarName = this.resourceURL.substring(9, this.resourceURL.indexOf(".jar!") + 4);
            try {
                JarFile jar = new JarFile(this.jarName);
                Manifest manifest = jar.getManifest();
                this.attributes = manifest.getMainAttributes();
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass()).error((Object)"Could not get version information, using defaults", (Throwable)ex);
            }
        }
    }

    public String getResourceURL() {
        return this.resourceURL;
    }

    public String getJarName() {
        return this.jarName;
    }

    public String getImplementationURL() {
        String result = DEFAULT_URL;
        if (this.attributes != null) {
            result = this.attributes.getValue("Implementation-URL");
        }
        return result;
    }

    public String getImplementationTitle() {
        String result = DEFAULT_TITLE;
        if (this.attributes != null) {
            result = this.attributes.getValue("Implementation-Title");
        }
        return result;
    }

    public String getImplementationVersion() {
        String result = "<i>unknown</i>";
        if (this.attributes != null) {
            result = this.attributes.getValue("Implementation-Version");
        }
        return result;
    }

    public String getImplementationVendor() {
        String result = "Jean Tessier";
        if (this.attributes != null) {
            result = this.attributes.getValue("Implementation-Vendor");
        }
        return result;
    }

    public String getImplementationDate() {
        String result = "<i>unknown</i>";
        if (this.attributes != null) {
            result = this.attributes.getValue("Implementation-Date");
        }
        return result;
    }

    public String getSpecificationTitle() {
        String result = DEFAULT_TITLE;
        if (this.attributes != null) {
            result = this.attributes.getValue("Specification-Title");
        }
        return result;
    }

    public String getSpecificationVersion() {
        String result = "<i>unknown</i>";
        if (this.attributes != null) {
            result = this.attributes.getValue("Specification-Version");
        }
        return result;
    }

    public String getSpecificationVendor() {
        String result = "Jean Tessier";
        if (this.attributes != null) {
            result = this.attributes.getValue("Specification-Vendor");
        }
        return result;
    }

    public String getSpecificationDate() {
        String result = "<i>unknown</i>";
        if (this.attributes != null) {
            result = this.attributes.getValue("Specification-Date");
        }
        return result;
    }

    public String getCopyrightHolder() {
        String result = "Jean Tessier";
        if (this.attributes != null) {
            result = this.attributes.getValue("Copyright-Holder");
        }
        return result;
    }

    public String getCopyrightDate() {
        String result = DEFAULT_COPYRIGHT_DATE;
        if (this.attributes != null) {
            result = this.attributes.getValue("Copyright-Date");
        }
        return result;
    }
}

