/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.SelectiveTraversalStrategy;
import com.jeantessier.dependency.TraversalStrategy;
import com.jeantessier.dependency.Visitor;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VisitorBase
implements Visitor {
    private TraversalStrategy strategy;
    private LinkedList<Node> currentNodes = new LinkedList();

    public VisitorBase() {
        this(new SelectiveTraversalStrategy());
    }

    public VisitorBase(TraversalStrategy strategy) {
        this.strategy = strategy;
    }

    protected TraversalStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public void traverseNodes(Collection<? extends Node> nodes) {
        if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
            Logger.getLogger(this.getClass()).debug((Object)("nodes = " + nodes));
        }
        for (Node node : this.getStrategy().order(nodes)) {
            node.accept(this);
        }
    }

    protected void traverseInbound(Collection<? extends Node> nodes) {
        for (Node node : this.getStrategy().order(nodes)) {
            node.acceptInbound(this);
        }
    }

    protected void traverseOutbound(Collection<? extends Node> nodes) {
        for (Node node : this.getStrategy().order(nodes)) {
            node.acceptOutbound(this);
        }
    }

    protected Node getCurrentNode() {
        Node result = null;
        if (!this.currentNodes.isEmpty()) {
            result = this.currentNodes.getLast();
        }
        if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
            Logger.getLogger(this.getClass()).debug((Object)(this.currentNodes + ": " + result));
        }
        return result;
    }

    protected void pushNode(Node currentNode) {
        if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
            Logger.getLogger(this.getClass()).debug((Object)(this.currentNodes + " + " + currentNode));
        }
        this.currentNodes.addLast(currentNode);
    }

    protected Node popNode() {
        Node result = this.currentNodes.removeLast();
        if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
            Logger.getLogger(this.getClass()).debug((Object)(this.currentNodes + " -> " + result));
        }
        return result;
    }

    @Override
    public void visitPackageNode(PackageNode node) {
        boolean inScope = this.isInScope(node);
        if (inScope) {
            this.preprocessPackageNode(node);
            if (this.getStrategy().doPreOutboundTraversal()) {
                this.traverseOutbound(node.getOutboundDependencies());
            }
            if (this.getStrategy().doPreInboundTraversal()) {
                this.traverseInbound(node.getInboundDependencies());
            }
            this.preprocessAfterDependenciesPackageNode(node);
        }
        this.traverseNodes(node.getClasses());
        if (inScope) {
            this.postprocessBeforeDependenciesPackageNode(node);
            if (this.getStrategy().doPostOutboundTraversal()) {
                this.traverseOutbound(node.getOutboundDependencies());
            }
            if (this.getStrategy().doPostInboundTraversal()) {
                this.traverseInbound(node.getInboundDependencies());
            }
            this.postprocessPackageNode(node);
        }
    }

    protected boolean isInScope(PackageNode node) {
        return this.getStrategy().isInScope(node);
    }

    protected void preprocessPackageNode(PackageNode node) {
        this.pushNode(node);
    }

    protected void preprocessAfterDependenciesPackageNode(PackageNode node) {
    }

    protected void postprocessBeforeDependenciesPackageNode(PackageNode node) {
    }

    protected void postprocessPackageNode(PackageNode node) {
        if (node.equals(this.getCurrentNode())) {
            this.popNode();
        }
    }

    @Override
    public void visitInboundPackageNode(PackageNode node) {
    }

    @Override
    public void visitOutboundPackageNode(PackageNode node) {
    }

    @Override
    public void visitClassNode(ClassNode node) {
        boolean inScope = this.isInScope(node);
        if (inScope) {
            this.preprocessClassNode(node);
            if (this.getStrategy().doPreOutboundTraversal()) {
                this.traverseOutbound(node.getOutboundDependencies());
            }
            if (this.getStrategy().doPreInboundTraversal()) {
                this.traverseInbound(node.getInboundDependencies());
            }
            this.preprocessAfterDependenciesClassNode(node);
        }
        this.traverseNodes(node.getFeatures());
        if (inScope) {
            this.postprocessBeforeDependenciesClassNode(node);
            if (this.getStrategy().doPostOutboundTraversal()) {
                this.traverseOutbound(node.getOutboundDependencies());
            }
            if (this.getStrategy().doPostInboundTraversal()) {
                this.traverseInbound(node.getInboundDependencies());
            }
            this.postprocessClassNode(node);
        }
    }

    protected boolean isInScope(ClassNode node) {
        return this.getStrategy().isInScope(node);
    }

    protected void preprocessClassNode(ClassNode node) {
        this.pushNode(node);
    }

    protected void preprocessAfterDependenciesClassNode(ClassNode node) {
    }

    protected void postprocessBeforeDependenciesClassNode(ClassNode node) {
    }

    protected void postprocessClassNode(ClassNode node) {
        if (node.equals(this.getCurrentNode())) {
            this.popNode();
        }
    }

    @Override
    public void visitInboundClassNode(ClassNode node) {
    }

    @Override
    public void visitOutboundClassNode(ClassNode node) {
    }

    @Override
    public void visitFeatureNode(FeatureNode node) {
        if (this.isInScope(node)) {
            this.preprocessFeatureNode(node);
            if (this.getStrategy().doPreOutboundTraversal()) {
                this.traverseOutbound(node.getOutboundDependencies());
            }
            if (this.getStrategy().doPreInboundTraversal()) {
                this.traverseInbound(node.getInboundDependencies());
            }
            if (this.getStrategy().doPostOutboundTraversal()) {
                this.traverseOutbound(node.getOutboundDependencies());
            }
            if (this.getStrategy().doPostInboundTraversal()) {
                this.traverseInbound(node.getInboundDependencies());
            }
            this.postprocessFeatureNode(node);
        }
    }

    protected boolean isInScope(FeatureNode node) {
        return this.getStrategy().isInScope(node);
    }

    protected void preprocessFeatureNode(FeatureNode node) {
        this.pushNode(node);
    }

    protected void postprocessFeatureNode(FeatureNode node) {
        if (node.equals(this.getCurrentNode())) {
            this.popNode();
        }
    }

    @Override
    public void visitInboundFeatureNode(FeatureNode node) {
    }

    @Override
    public void visitOutboundFeatureNode(FeatureNode node) {
    }
}

