/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.Printer;
import com.jeantessier.dependency.TraversalStrategy;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextPrinter
extends Printer {
    private static final Perl5Util perl = new Perl5Util();
    private boolean showInferred = true;
    private Map<Node, Integer> dependencies = new TreeMap<Node, Integer>();

    protected static Perl5Util perl() {
        return perl;
    }

    public TextPrinter(PrintWriter out) {
        super(out);
    }

    public TextPrinter(TraversalStrategy strategy, PrintWriter out) {
        super(strategy, out);
    }

    public boolean isShowInferred() {
        return this.showInferred;
    }

    public void setShowInferred(boolean showInferred) {
        this.showInferred = showInferred;
    }

    @Override
    protected void preprocessPackageNode(PackageNode node) {
        Logger.getLogger(this.getClass()).debug((Object)("Printing package \"" + node + "\" and its " + node.getInboundDependencies().size() + " inbounds and " + node.getOutboundDependencies().size() + " outbounds"));
        super.preprocessPackageNode(node);
        this.raiseIndent();
        this.dependencies.clear();
    }

    @Override
    protected void preprocessAfterDependenciesPackageNode(PackageNode node) {
        Logger.getLogger(this.getClass()).debug((Object)("Package \"" + node + "\" with " + node.getInboundDependencies().size() + " inbounds and " + node.getOutboundDependencies().size() + " outbounds had " + this.dependencies.size() + " dependencies."));
        if (this.shouldShowPackageNode(node) || !this.dependencies.isEmpty()) {
            this.lowerIndent();
            this.indent().printScopeNodeName(node).eol();
            this.raiseIndent();
        }
        this.printDependencies(node, this.dependencies);
    }

    @Override
    protected void postprocessPackageNode(PackageNode node) {
        this.lowerIndent();
        super.postprocessPackageNode(node);
    }

    @Override
    public void visitInboundPackageNode(PackageNode node) {
        if (this.isShowInbounds()) {
            Logger.getLogger(this.getClass()).debug((Object)("Printing \"" + this.getCurrentNode() + "\" <-- \"" + node + "\""));
            Integer i = this.dependencies.get(node);
            if (i != null) {
                this.dependencies.put(node, i - 1);
            } else {
                this.dependencies.put(node, -1);
            }
        } else {
            Logger.getLogger(this.getClass()).debug((Object)("Ignoring \"" + this.getCurrentNode() + "\" <-- \"" + node + "\""));
        }
    }

    @Override
    public void visitOutboundPackageNode(PackageNode node) {
        if (this.isShowOutbounds()) {
            Logger.getLogger(this.getClass()).debug((Object)("Printing \"" + this.getCurrentNode() + "\" --> \"" + node + "\""));
            Integer i = this.dependencies.get(node);
            if (i != null) {
                this.dependencies.put(node, i + 1);
            } else {
                this.dependencies.put(node, 1);
            }
        } else {
            Logger.getLogger(this.getClass()).debug((Object)("Ignoring \"" + this.getCurrentNode() + "\" --> \"" + node + "\""));
        }
    }

    @Override
    protected void preprocessClassNode(ClassNode node) {
        Logger.getLogger(this.getClass()).debug((Object)("Printing class \"" + node + "\" and its " + node.getInboundDependencies().size() + " inbounds and " + node.getOutboundDependencies().size() + " outbounds"));
        super.preprocessClassNode(node);
        this.raiseIndent();
        this.dependencies.clear();
    }

    @Override
    protected void preprocessAfterDependenciesClassNode(ClassNode node) {
        Logger.getLogger(this.getClass()).debug((Object)("Class \"" + node + "\" with " + node.getInboundDependencies().size() + " inbounds and " + node.getOutboundDependencies().size() + " outbounds had " + this.dependencies.size() + " dependencies."));
        if (this.shouldShowClassNode(node) || !this.dependencies.isEmpty()) {
            this.lowerIndent();
            this.indent().printScopeNodeName(node, node.getSimpleName()).eol();
            this.raiseIndent();
        }
        this.printDependencies(node, this.dependencies);
    }

    @Override
    protected void postprocessClassNode(ClassNode node) {
        this.lowerIndent();
        super.postprocessClassNode(node);
    }

    @Override
    public void visitInboundClassNode(ClassNode node) {
        if (this.isShowInbounds()) {
            Logger.getLogger(this.getClass()).debug((Object)("Printing \"" + this.getCurrentNode() + "\" <-- \"" + node + "\""));
            Integer i = this.dependencies.get(node);
            if (i != null) {
                this.dependencies.put(node, i - 1);
            } else {
                this.dependencies.put(node, -1);
            }
        } else {
            Logger.getLogger(this.getClass()).debug((Object)("Ignoring \"" + this.getCurrentNode() + "\" <-- \"" + node + "\""));
        }
    }

    @Override
    public void visitOutboundClassNode(ClassNode node) {
        if (this.isShowOutbounds()) {
            Logger.getLogger(this.getClass()).debug((Object)("Printing \"" + this.getCurrentNode() + "\" --> \"" + node + "\""));
            Integer i = this.dependencies.get(node);
            if (i != null) {
                this.dependencies.put(node, i + 1);
            } else {
                this.dependencies.put(node, 1);
            }
        } else {
            Logger.getLogger(this.getClass()).debug((Object)("Ignoring \"" + this.getCurrentNode() + "\" --> \"" + node + "\""));
        }
    }

    @Override
    protected void preprocessFeatureNode(FeatureNode node) {
        Logger.getLogger(this.getClass()).debug((Object)("Printing feature \"" + node + "\" and its " + node.getInboundDependencies().size() + " inbounds and " + node.getOutboundDependencies().size() + " outbounds"));
        super.preprocessFeatureNode(node);
        this.raiseIndent();
        this.dependencies.clear();
    }

    @Override
    protected void postprocessFeatureNode(FeatureNode node) {
        Logger.getLogger(this.getClass()).debug((Object)("Feature \"" + node + "\" with " + node.getInboundDependencies().size() + " inbounds and " + node.getOutboundDependencies().size() + " outbounds had " + this.dependencies.size() + " dependencies."));
        if (this.shouldShowFeatureNode(node) || !this.dependencies.isEmpty()) {
            this.lowerIndent();
            if (TextPrinter.perl().match("/([^\\.]*\\(.*\\))$/", node.getName())) {
                this.indent().printScopeNodeName(node, TextPrinter.perl().group(1)).eol();
            } else if (TextPrinter.perl().match("/([^\\.]*)$/", node.getName())) {
                this.indent().printScopeNodeName(node, TextPrinter.perl().group(1)).eol();
            } else {
                this.indent().printScopeNodeName(node, node.getName().substring(node.getName().lastIndexOf(46) + 1)).eol();
            }
            this.raiseIndent();
        }
        this.printDependencies(node, this.dependencies);
        this.lowerIndent();
        super.postprocessFeatureNode(node);
    }

    @Override
    public void visitInboundFeatureNode(FeatureNode node) {
        if (this.isShowInbounds()) {
            Logger.getLogger(this.getClass()).debug((Object)("Printing \"" + this.getCurrentNode() + "\" <-- \"" + node + "\""));
            Integer i = this.dependencies.get(node);
            if (i != null) {
                this.dependencies.put(node, i - 1);
            } else {
                this.dependencies.put(node, -1);
            }
        } else {
            Logger.getLogger(this.getClass()).debug((Object)("Ignoring \"" + this.getCurrentNode() + "\" <-- \"" + node + "\""));
        }
    }

    @Override
    public void visitOutboundFeatureNode(FeatureNode node) {
        if (this.isShowOutbounds()) {
            Logger.getLogger(this.getClass()).debug((Object)("Printing \"" + this.getCurrentNode() + "\" --> \"" + node + "\""));
            Integer i = this.dependencies.get(node);
            if (i != null) {
                this.dependencies.put(node, i + 1);
            } else {
                this.dependencies.put(node, 1);
            }
        } else {
            Logger.getLogger(this.getClass()).debug((Object)("Ignoring \"" + this.getCurrentNode() + "\" --> \"" + node + "\""));
        }
    }

    @Override
    protected Printer printNodeName(Node node, String name) {
        super.printNodeName(node, name);
        if (this.isShowInferred() && !node.isConfirmed()) {
            this.append(" *");
        }
        return this;
    }

    protected void printDependencies(Node node, Map<Node, Integer> dependencies) {
        for (Map.Entry<Node, Integer> entry : dependencies.entrySet()) {
            if (entry.getValue() < 0) {
                this.indent().append("<-- ").printDependencyNodeName(entry.getKey()).eol();
                continue;
            }
            if (entry.getValue() > 0) {
                this.indent().append("--> ").printDependencyNodeName(entry.getKey()).eol();
                continue;
            }
            this.indent().append("<-> ").printDependencyNodeName(entry.getKey()).eol();
        }
    }
}

