/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.Cycle;
import com.jeantessier.dependency.CyclePrinter;
import com.jeantessier.dependency.Node;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextCyclePrinter
implements CyclePrinter {
    protected PrintWriter out;
    private String indentText = "    ";
    private int indentLevel;

    public TextCyclePrinter(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void setIndentText(String indentText) {
        this.indentText = indentText;
    }

    @Override
    public void visitCycles(Collection<Cycle> cycles) {
        for (Cycle cycle : cycles) {
            this.visitCycle(cycle);
        }
    }

    @Override
    public void visitCycle(Cycle cycle) {
        Node previousNode;
        Iterator<Node> i = cycle.getPath().iterator();
        Node currentNode = i.next();
        this.visitFirstNode(currentNode);
        while (i.hasNext()) {
            previousNode = currentNode;
            currentNode = i.next();
            this.visitNode(previousNode, currentNode);
        }
        previousNode = currentNode;
        currentNode = cycle.getPath().iterator().next();
        this.visitNode(previousNode, currentNode);
    }

    private void visitFirstNode(Node node) {
        this.indentLevel = 0;
        this.printFirstNode(node);
    }

    private void visitNode(Node previousNode, Node currentNode) {
        ++this.indentLevel;
        this.indent();
        this.printNode(previousNode, currentNode);
    }

    private void indent() {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.out.print(this.indentText);
        }
    }

    protected void printFirstNode(Node node) {
        this.out.println(node);
    }

    protected void printNode(Node previousNode, Node currentNode) {
        this.out.print("--> ");
        this.out.println(currentNode);
    }
}

