/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.ComprehensiveSelectionCriteria;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.SelectionCriteria;
import com.jeantessier.dependency.TraversalStrategy;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectiveTraversalStrategy
implements TraversalStrategy {
    private SelectionCriteria scopeCriteria;
    private SelectionCriteria filterCriteria;
    private boolean preOutboundTraversal = true;
    private boolean preInboundTraversal = true;
    private boolean postOutboundTraversal = false;
    private boolean postInboundTraversal = false;

    public SelectiveTraversalStrategy() {
        this(new ComprehensiveSelectionCriteria(), new ComprehensiveSelectionCriteria());
    }

    public SelectiveTraversalStrategy(SelectionCriteria scopeCriteria, SelectionCriteria filterCriteria) {
        this.scopeCriteria = scopeCriteria;
        this.filterCriteria = filterCriteria;
    }

    @Override
    public boolean doPreOutboundTraversal() {
        return this.preOutboundTraversal;
    }

    @Override
    public void setPreOutboundTraversal(boolean preOutboundTraversal) {
        this.preOutboundTraversal = preOutboundTraversal;
    }

    @Override
    public boolean doPreInboundTraversal() {
        return this.preInboundTraversal;
    }

    @Override
    public void setPreInboundTraversal(boolean preInboundTraversal) {
        this.preInboundTraversal = preInboundTraversal;
    }

    @Override
    public boolean doPostOutboundTraversal() {
        return this.postOutboundTraversal;
    }

    @Override
    public void setPostOutboundTraversal(boolean postOutboundTraversal) {
        this.postOutboundTraversal = postOutboundTraversal;
    }

    @Override
    public boolean doPostInboundTraversal() {
        return this.postInboundTraversal;
    }

    @Override
    public void setPostInboundTraversal(boolean postInboundTraversal) {
        this.postInboundTraversal = postInboundTraversal;
    }

    @Override
    public boolean isInScope(PackageNode node) {
        return this.scopeCriteria.matches(node);
    }

    @Override
    public boolean isInScope(ClassNode node) {
        return this.scopeCriteria.matches(node);
    }

    @Override
    public boolean isInScope(FeatureNode node) {
        return this.scopeCriteria.matches(node);
    }

    @Override
    public boolean isInFilter(PackageNode node) {
        return this.filterCriteria.matches(node);
    }

    @Override
    public boolean isInFilter(ClassNode node) {
        return this.filterCriteria.matches(node);
    }

    @Override
    public boolean isInFilter(FeatureNode node) {
        return this.filterCriteria.matches(node);
    }

    @Override
    public Collection<? extends Node> order(Collection<? extends Node> collection) {
        return new ArrayList<Node>(collection);
    }
}

