/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.SelectionCriteria;
import com.jeantessier.text.MaximumCapacityPatternCache;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.oro.text.PatternCache;
import org.apache.oro.text.perl.Perl5Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegularExpressionSelectionCriteria
implements SelectionCriteria {
    private Perl5Util perl = new Perl5Util((PatternCache)new MaximumCapacityPatternCache());
    private List<String> globalIncludes = new LinkedList<String>();
    private List<String> globalExcludes = new LinkedList<String>();
    private boolean matchingPackages = true;
    private List<String> packageIncludes = new LinkedList<String>();
    private List<String> packageExcludes = new LinkedList<String>();
    private boolean matchingClasses = true;
    private List<String> classIncludes = new LinkedList<String>();
    private List<String> classExcludes = new LinkedList<String>();
    private boolean matchingFeatures = true;
    private List<String> featureIncludes = new LinkedList<String>();
    private List<String> featureExcludes = new LinkedList<String>();

    public RegularExpressionSelectionCriteria() {
    }

    public RegularExpressionSelectionCriteria(String initialGlobalIncludes) {
        this.setGlobalIncludes(initialGlobalIncludes);
    }

    public List<String> getGlobalIncludes() {
        return this.globalIncludes;
    }

    public void setGlobalIncludes(String globalIncludes) {
        this.setGlobalIncludes(RegularExpressionSelectionCriteria.parseRE(globalIncludes));
    }

    public void setGlobalIncludes(List<String> globalIncludes) {
        this.globalIncludes = globalIncludes;
    }

    public List<String> getGlobalExcludes() {
        return this.globalExcludes;
    }

    public void setGlobalExcludes(String globalExcludes) {
        this.setGlobalExcludes(RegularExpressionSelectionCriteria.parseRE(globalExcludes));
    }

    public void setGlobalExcludes(List<String> globalExcludes) {
        this.globalExcludes = globalExcludes;
    }

    @Override
    public boolean isMatchingPackages() {
        return this.matchingPackages;
    }

    public void setMatchingPackages(boolean matchingPackages) {
        this.matchingPackages = matchingPackages;
    }

    public List<String> getPackageIncludes() {
        return this.packageIncludes;
    }

    public void setPackageIncludes(String packageIncludes) {
        this.setPackageIncludes(RegularExpressionSelectionCriteria.parseRE(packageIncludes));
    }

    public void setPackageIncludes(List<String> packageIncludes) {
        this.packageIncludes = packageIncludes;
    }

    public List<String> getPackageExcludes() {
        return this.packageExcludes;
    }

    public void setPackageExcludes(String packageExcludes) {
        this.setPackageExcludes(RegularExpressionSelectionCriteria.parseRE(packageExcludes));
    }

    public void setPackageExcludes(List<String> packageExcludes) {
        this.packageExcludes = packageExcludes;
    }

    @Override
    public boolean isMatchingClasses() {
        return this.matchingClasses;
    }

    public void setMatchingClasses(boolean matchingClasses) {
        this.matchingClasses = matchingClasses;
    }

    public List<String> getClassIncludes() {
        return this.classIncludes;
    }

    public void setClassIncludes(String classIncludes) {
        this.setClassIncludes(RegularExpressionSelectionCriteria.parseRE(classIncludes));
    }

    public void setClassIncludes(List<String> classIncludes) {
        this.classIncludes = classIncludes;
    }

    public List<String> getClassExcludes() {
        return this.classExcludes;
    }

    public void setClassExcludes(String classExcludes) {
        this.setClassExcludes(RegularExpressionSelectionCriteria.parseRE(classExcludes));
    }

    public void setClassExcludes(List<String> classExcludes) {
        this.classExcludes = classExcludes;
    }

    @Override
    public boolean isMatchingFeatures() {
        return this.matchingFeatures;
    }

    public void setMatchingFeatures(boolean matchingFeatures) {
        this.matchingFeatures = matchingFeatures;
    }

    public List<String> getFeatureIncludes() {
        return this.featureIncludes;
    }

    public void setFeatureIncludes(String featureIncludes) {
        this.setFeatureIncludes(RegularExpressionSelectionCriteria.parseRE(featureIncludes));
    }

    public void setFeatureIncludes(List<String> featureIncludes) {
        this.featureIncludes = featureIncludes;
    }

    public List<String> getFeatureExcludes() {
        return this.featureExcludes;
    }

    public void setFeatureExcludes(String featureExcludes) {
        this.setFeatureExcludes(RegularExpressionSelectionCriteria.parseRE(featureExcludes));
    }

    public void setFeatureExcludes(List<String> featureExcludes) {
        this.featureExcludes = featureExcludes;
    }

    @Override
    public boolean matches(PackageNode node) {
        return this.isMatchingPackages() && this.matchesPackageName(node.getName());
    }

    @Override
    public boolean matches(ClassNode node) {
        return this.isMatchingClasses() && this.matchesClassName(node.getName());
    }

    @Override
    public boolean matches(FeatureNode node) {
        return this.isMatchingFeatures() && this.matchesFeatureName(node.getName());
    }

    @Override
    public boolean matchesPackageName(String name) {
        return this.matches(this.getGlobalIncludes(), this.getPackageIncludes(), name) && !this.matches(this.getGlobalExcludes(), this.getPackageExcludes(), name);
    }

    @Override
    public boolean matchesClassName(String name) {
        return this.matches(this.getGlobalIncludes(), this.getClassIncludes(), name) && !this.matches(this.getGlobalExcludes(), this.getClassExcludes(), name);
    }

    @Override
    public boolean matchesFeatureName(String name) {
        return this.matches(this.getGlobalIncludes(), this.getFeatureIncludes(), name) && !this.matches(this.getGlobalExcludes(), this.getFeatureExcludes(), name);
    }

    private boolean matches(List<String> globalRegularExpressions, List<String> regularExpressions, String name) {
        boolean found = false;
        Iterator<String> i = globalRegularExpressions.iterator();
        while (!found && i.hasNext()) {
            found = this.perl.match(i.next(), name);
        }
        i = regularExpressions.iterator();
        while (!found && i.hasNext()) {
            found = this.perl.match(i.next(), name);
        }
        return found;
    }

    static List<String> parseRE(String re) {
        LinkedList<String> result = new LinkedList<String>();
        Logger logger = Logger.getLogger(RegularExpressionSelectionCriteria.class);
        logger.debug((Object)("ParseRE \"" + re + "\""));
        int length = re.length();
        int start = 0;
        int stop = -1;
        while (start < length && stop < length) {
            String separator = null;
            while (start < length && stop < start) {
                if (re.charAt(start) == 'm' && start + 1 < length) {
                    separator = re.substring(start + 1, start + 2);
                    stop = start + 2;
                    continue;
                }
                if (re.charAt(start) == '/') {
                    separator = "/";
                    stop = start + 1;
                    continue;
                }
                ++start;
            }
            logger.debug((Object)("start is " + start));
            logger.debug((Object)("separator is " + separator));
            while (stop < length && start < stop) {
                stop = re.indexOf(separator, stop);
                logger.debug((Object)("indexOf() is " + stop));
                if (stop == -1 || re.charAt(stop - 1) != '\\') {
                    if (stop == -1) {
                        stop = length;
                    } else {
                        ++stop;
                        while (stop < length && (re.charAt(stop) == 'g' || re.charAt(stop) == 'i' || re.charAt(stop) == 'm' || re.charAt(stop) == 'o' || re.charAt(stop) == 's' || re.charAt(stop) == 'x')) {
                            ++stop;
                        }
                    }
                    logger.debug((Object)("stop is " + stop));
                    logger.debug((Object)("candidate is \"" + re.substring(start, stop) + "\""));
                    result.add(re.substring(start, stop));
                    start = stop + 1;
                    continue;
                }
                ++stop;
            }
        }
        return result;
    }
}

