/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.Visitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageNode
extends Node {
    private Collection<ClassNode> classes = new HashSet<ClassNode>();

    public PackageNode(String name, boolean concrete) {
        super(name, concrete);
    }

    @Override
    void setConfirmed(boolean confirmed) {
        Iterator<ClassNode> i = this.getClasses().iterator();
        while (!confirmed && i.hasNext()) {
            confirmed = i.next().isConfirmed();
        }
        super.setConfirmed(confirmed);
    }

    public void addClass(ClassNode node) {
        this.classes.add(node);
    }

    public void removeClass(ClassNode node) {
        this.classes.remove(node);
    }

    public Collection<ClassNode> getClasses() {
        return Collections.unmodifiableCollection(this.classes);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitPackageNode(this);
    }

    @Override
    public void acceptInbound(Visitor visitor) {
        visitor.visitInboundPackageNode(this);
    }

    @Override
    public void acceptOutbound(Visitor visitor) {
        visitor.visitOutboundPackageNode(this);
    }
}

