/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.PackageNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeFactory {
    private static final Perl5Util perl = new Perl5Util();
    private Map<String, PackageNode> packages = new HashMap<String, PackageNode>();
    private Map<String, ClassNode> classes = new HashMap<String, ClassNode>();
    private Map<String, FeatureNode> features = new HashMap<String, FeatureNode>();

    public PackageNode createPackage(String packageName) {
        return this.createPackage(packageName, false);
    }

    public PackageNode createPackage(String packageName, boolean confirmed) {
        Logger.getLogger(this.getClass()).debug((Object)("Create package \"" + packageName + "\""));
        PackageNode result = this.packages.get(packageName);
        if (result == null) {
            result = new PackageNode(packageName, confirmed);
            this.packages.put(packageName, result);
            Logger.getLogger(this.getClass()).debug((Object)("Added package \"" + packageName + "\""));
        }
        if (confirmed && !result.isConfirmed()) {
            result.setConfirmed(confirmed);
            Logger.getLogger(this.getClass()).debug((Object)("Package \"" + packageName + "\" is confirmed"));
        }
        return result;
    }

    void deletePackage(PackageNode node) {
        Logger.getLogger(this.getClass()).debug((Object)("Delete package \"" + node + "\""));
        this.packages.remove(node.getName());
    }

    public Map<String, PackageNode> getPackages() {
        return Collections.unmodifiableMap(this.packages);
    }

    public ClassNode createClass(String className) {
        return this.createClass(className, false);
    }

    public ClassNode createClass(String className, boolean confirmed) {
        Logger.getLogger(this.getClass()).debug((Object)("Create class \"" + className + "\""));
        ClassNode result = this.classes.get(className);
        if (result == null) {
            String packageName = "";
            int pos = className.lastIndexOf(46);
            if (pos != -1) {
                packageName = className.substring(0, pos);
            }
            PackageNode parent = this.createPackage(packageName, confirmed);
            result = new ClassNode(parent, className, confirmed);
            parent.addClass(result);
            this.classes.put(className, result);
            Logger.getLogger(this.getClass()).debug((Object)("Added class \"" + className + "\""));
        }
        if (confirmed && !result.isConfirmed()) {
            result.setConfirmed(confirmed);
            Logger.getLogger(this.getClass()).debug((Object)("Class \"" + className + "\" is confirmed"));
        }
        return result;
    }

    void deleteClass(ClassNode node) {
        Logger.getLogger(this.getClass()).debug((Object)("Delete class \"" + node + "\""));
        node.getPackageNode().removeClass(node);
        this.classes.remove(node.getName());
    }

    public Map<String, ClassNode> getClasses() {
        return Collections.unmodifiableMap(this.classes);
    }

    public FeatureNode createFeature(String featureName) {
        return this.createFeature(featureName, false);
    }

    public FeatureNode createFeature(String featureName, boolean confirmed) {
        Logger.getLogger(this.getClass()).debug((Object)("Create feature \"" + featureName + "\""));
        FeatureNode result = this.features.get(featureName);
        if (result == null) {
            String parentName = perl.match("/^(.*)\\.[^\\.]*\\(.*\\)$/", featureName) ? perl.group(1) : (perl.match("/^(.*)\\.[^\\.]*$/", featureName) ? perl.group(1) : "");
            ClassNode parent = this.createClass(parentName, confirmed);
            result = new FeatureNode(parent, featureName, confirmed);
            parent.addFeature(result);
            this.features.put(featureName, result);
            Logger.getLogger(this.getClass()).debug((Object)("Added feature \"" + featureName + "\""));
        }
        if (confirmed && !result.isConfirmed()) {
            result.setConfirmed(confirmed);
            Logger.getLogger(this.getClass()).debug((Object)("Feature \"" + featureName + "\" is confirmed"));
        }
        return result;
    }

    void deleteFeature(FeatureNode node) {
        Logger.getLogger(this.getClass()).debug((Object)("Delete feature \"" + node + "\""));
        node.getClassNode().removeFeature(node);
        this.features.remove(node.getName());
    }

    public Map<String, FeatureNode> getFeatures() {
        return Collections.unmodifiableMap(this.features);
    }
}

