/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.Printer;
import com.jeantessier.dependency.TextPrinter;
import com.jeantessier.dependency.TraversalStrategy;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLPrinter
extends TextPrinter {
    private MessageFormat urlFormat;

    public HTMLPrinter(PrintWriter out, MessageFormat format) {
        super(out);
        this.urlFormat = format;
    }

    public HTMLPrinter(TraversalStrategy strategy, PrintWriter out, MessageFormat format) {
        super(strategy, out);
        this.urlFormat = format;
    }

    @Override
    protected Printer printScopeNodeName(Node node, String name) {
        String fullName;
        String escapedName = fullName = node.getName();
        escapedName = HTMLPrinter.perl().substitute("s/\\(/\\\\(/g", escapedName);
        escapedName = HTMLPrinter.perl().substitute("s/\\)/\\\\)/g", escapedName);
        escapedName = HTMLPrinter.perl().substitute("s/\\$/\\\\\\$/g", escapedName);
        Object[] urlArgument = new Object[]{escapedName};
        String url = this.urlFormat.format(urlArgument);
        StringBuffer link = new StringBuffer("<a");
        link.append(" class=\"scope");
        if (this.isShowInferred() && !node.isConfirmed()) {
            link.append(" inferred");
        }
        link.append("\"");
        link.append(" href=\"").append(url).append("\"");
        link.append(" id=\"").append(fullName).append("\"");
        link.append(">");
        link.append(name);
        link.append("</a>");
        this.openPotentialInferredSpan(node);
        this.printNodeName(node, link.toString());
        this.closePotentialInferredSpan(node);
        return this;
    }

    @Override
    protected void printDependencies(Node node, Map<Node, Integer> dependencies) {
        Object[] urlArgument = new Object[1];
        String scopeNodeName = node.getName();
        for (Map.Entry<Node, Integer> entry : dependencies.entrySet()) {
            String idConjunction;
            String symbol;
            String rawName;
            Node dependency = entry.getKey();
            String escapedName = rawName = dependency.getName();
            escapedName = HTMLPrinter.perl().substitute("s/\\(/\\\\(/g", escapedName);
            escapedName = HTMLPrinter.perl().substitute("s/\\)/\\\\)/g", escapedName);
            escapedName = HTMLPrinter.perl().substitute("s/\\$/\\\\\\$/g", escapedName);
            urlArgument[0] = escapedName;
            String url = this.urlFormat.format(urlArgument);
            if (entry.getValue() < 0) {
                symbol = "&lt;--";
                idConjunction = "_from_";
            } else if (entry.getValue() > 0) {
                symbol = "--&gt;";
                idConjunction = "_to_";
            } else {
                symbol = "&lt;-&gt;";
                idConjunction = "_bidirectional_";
            }
            StringBuffer link = new StringBuffer("<a");
            if (this.isShowInferred() && !dependency.isConfirmed()) {
                link.append(" class=\"inferred\"");
            }
            link.append(" href=\"").append(url).append("\"");
            link.append(" id=\"").append(scopeNodeName).append(idConjunction).append(rawName).append("\"");
            link.append(">");
            link.append(rawName);
            link.append("</a>");
            this.indent();
            this.openPotentialInferredSpan(dependency);
            this.append(symbol).append(" ").printDependencyNodeName(dependency, link.toString());
            this.closePotentialInferredSpan(dependency);
            this.eol();
        }
    }

    private void openPotentialInferredSpan(Node node) {
        if (this.isShowInferred() && !node.isConfirmed()) {
            this.append("<span class=\"inferred\">");
        }
    }

    private void closePotentialInferredSpan(Node node) {
        if (this.isShowInferred() && !node.isConfirmed()) {
            this.append("</span>");
        }
    }
}

