/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.TextCyclePrinter;
import java.io.PrintWriter;
import java.text.MessageFormat;
import org.apache.oro.text.perl.Perl5Util;

public class HTMLCyclePrinter
extends TextCyclePrinter {
    private static final Perl5Util perl = new Perl5Util();
    private MessageFormat urlFormat;

    protected static Perl5Util perl() {
        return perl;
    }

    public HTMLCyclePrinter(PrintWriter out, MessageFormat urlFormat) {
        super(out);
        this.urlFormat = urlFormat;
    }

    protected void printFirstNode(Node node) {
        String fullName = node.getName();
        String url = this.formatUrl(fullName);
        this.out.print("<a class=\"scope\" href=\"");
        this.out.print(url);
        this.out.print("\" id=\"");
        this.out.print(fullName);
        this.out.print("\">");
        this.out.print(fullName);
        this.out.print("</a>");
        this.out.println();
    }

    protected void printNode(Node previousNode, Node currentNode) {
        String fullName = currentNode.getName();
        String url = this.formatUrl(fullName);
        this.out.print("--&gt; <a href=\"");
        this.out.print(url);
        this.out.print("\" id=\"");
        this.out.print(previousNode);
        this.out.print("_to_");
        this.out.print(fullName);
        this.out.print("\">");
        this.out.print(fullName);
        this.out.print("</a>");
        this.out.println();
    }

    private String formatUrl(String fullName) {
        String escapedName = fullName;
        escapedName = HTMLCyclePrinter.perl().substitute("s/\\(/\\\\(/g", escapedName);
        escapedName = HTMLCyclePrinter.perl().substitute("s/\\)/\\\\)/g", escapedName);
        escapedName = HTMLCyclePrinter.perl().substitute("s/\\$/\\\\\\$/g", escapedName);
        Object[] urlArgument = new Object[]{escapedName};
        return this.urlFormat.format(urlArgument);
    }
}

