/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.GraphCopier;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.SelectionCriteria;
import com.jeantessier.dependency.SelectiveTraversalStrategy;

public class GraphSummarizer
extends GraphCopier {
    private SelectionCriteria scopeCriteria;
    private SelectionCriteria filterCriteria;

    public GraphSummarizer(SelectionCriteria scopeCriteria, SelectionCriteria filterCriteria) {
        super(new SelectiveTraversalStrategy(scopeCriteria, filterCriteria));
        this.scopeCriteria = scopeCriteria;
        this.filterCriteria = filterCriteria;
    }

    protected boolean isInScope(PackageNode node) {
        return this.scopeCriteria.matchesPackageName(node.getName());
    }

    protected void preprocessPackageNode(PackageNode node) {
        if (this.scopeCriteria.isMatchingPackages()) {
            super.preprocessPackageNode(node);
        }
    }

    protected void postprocessPackageNode(PackageNode node) {
        if (this.scopeCriteria.isMatchingPackages()) {
            super.postprocessPackageNode(node);
        }
    }

    public void visitInboundPackageNode(PackageNode node) {
        if (this.getCurrentNode() != null && this.filterCriteria.matchesPackageName(node.getName()) && this.filterCriteria.isMatchingPackages()) {
            this.copy(this.getFilterFactory(), node).addDependency(this.getCurrentNode());
        }
    }

    public void visitOutboundPackageNode(PackageNode node) {
        if (this.getCurrentNode() != null && this.filterCriteria.matchesPackageName(node.getName()) && this.filterCriteria.isMatchingPackages()) {
            this.getCurrentNode().addDependency(this.copy(this.getFilterFactory(), node));
        }
    }

    protected boolean isInScope(ClassNode node) {
        return this.scopeCriteria.matchesClassName(node.getName());
    }

    protected void preprocessClassNode(ClassNode node) {
        if (this.scopeCriteria.isMatchingClasses()) {
            super.preprocessClassNode(node);
        }
    }

    protected void postprocessClassNode(ClassNode node) {
        if (this.scopeCriteria.isMatchingClasses()) {
            super.postprocessClassNode(node);
        }
    }

    public void visitInboundClassNode(ClassNode node) {
        if (this.getCurrentNode() != null && this.filterCriteria.matchesClassName(node.getName())) {
            if (this.filterCriteria.isMatchingClasses()) {
                this.copy(this.getFilterFactory(), node).addDependency(this.getCurrentNode());
            } else if (this.filterCriteria.isMatchingPackages()) {
                this.copy(this.getFilterFactory(), node.getPackageNode()).addDependency(this.getCurrentNode());
            }
        }
    }

    public void visitOutboundClassNode(ClassNode node) {
        if (this.getCurrentNode() != null && this.filterCriteria.matchesClassName(node.getName())) {
            if (this.filterCriteria.isMatchingClasses()) {
                this.getCurrentNode().addDependency(this.copy(this.getFilterFactory(), node));
            } else if (this.filterCriteria.isMatchingPackages()) {
                this.getCurrentNode().addDependency(this.copy(this.getFilterFactory(), node.getPackageNode()));
            }
        }
    }

    protected boolean isInScope(FeatureNode node) {
        return this.scopeCriteria.matchesFeatureName(node.getName());
    }

    protected void preprocessFeatureNode(FeatureNode node) {
        if (this.scopeCriteria.isMatchingFeatures()) {
            super.preprocessFeatureNode(node);
        }
    }

    protected void postprocessFeatureNode(FeatureNode node) {
        if (this.scopeCriteria.isMatchingFeatures()) {
            super.postprocessFeatureNode(node);
        }
    }

    public void visitInboundFeatureNode(FeatureNode node) {
        if (this.getCurrentNode() != null && this.filterCriteria.matchesFeatureName(node.getName())) {
            if (this.filterCriteria.isMatchingFeatures()) {
                this.copy(this.getFilterFactory(), node).addDependency(this.getCurrentNode());
            } else if (this.filterCriteria.isMatchingClasses()) {
                this.copy(this.getFilterFactory(), node.getClassNode()).addDependency(this.getCurrentNode());
            } else if (this.filterCriteria.isMatchingPackages()) {
                this.copy(this.getFilterFactory(), node.getClassNode().getPackageNode()).addDependency(this.getCurrentNode());
            }
        }
    }

    public void visitOutboundFeatureNode(FeatureNode node) {
        if (this.getCurrentNode() != null && this.filterCriteria.matchesFeatureName(node.getName())) {
            if (this.filterCriteria.isMatchingFeatures()) {
                this.getCurrentNode().addDependency(this.copy(this.getFilterFactory(), node));
            } else if (this.filterCriteria.isMatchingClasses()) {
                this.getCurrentNode().addDependency(this.copy(this.getFilterFactory(), node.getClassNode()));
            } else if (this.filterCriteria.isMatchingPackages()) {
                this.getCurrentNode().addDependency(this.copy(this.getFilterFactory(), node.getClassNode().getPackageNode()));
            }
        }
    }
}

