/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.TraversalStrategy;
import com.jeantessier.dependency.VisitorBase;

public class GraphCopier
extends VisitorBase {
    private NodeFactory scopeFactory = new NodeFactory();
    private NodeFactory filterFactory = new NodeFactory();

    public GraphCopier() {
    }

    public GraphCopier(TraversalStrategy strategy) {
        super(strategy);
    }

    public NodeFactory getScopeFactory() {
        return this.scopeFactory;
    }

    public NodeFactory getFilterFactory() {
        return this.filterFactory;
    }

    protected void preprocessPackageNode(PackageNode node) {
        super.preprocessPackageNode(this.copy(this.getScopeFactory(), node));
    }

    public void visitInboundPackageNode(PackageNode node) {
        if (this.getStrategy().isInFilter(node)) {
            this.copy(this.getFilterFactory(), node).addDependency(this.getCurrentNode());
        }
    }

    public void visitOutboundPackageNode(PackageNode node) {
        if (this.getStrategy().isInFilter(node)) {
            this.getCurrentNode().addDependency(this.copy(this.getFilterFactory(), node));
        }
    }

    protected void preprocessClassNode(ClassNode node) {
        super.preprocessClassNode(this.copy(this.getScopeFactory(), node));
    }

    public void visitInboundClassNode(ClassNode node) {
        if (this.getStrategy().isInFilter(node)) {
            this.copy(this.getFilterFactory(), node).addDependency(this.getCurrentNode());
        }
    }

    public void visitOutboundClassNode(ClassNode node) {
        if (this.getStrategy().isInFilter(node)) {
            this.getCurrentNode().addDependency(this.copy(this.getFilterFactory(), node));
        }
    }

    protected void preprocessFeatureNode(FeatureNode node) {
        NodeFactory factory = this.getScopeFactory();
        super.preprocessFeatureNode(this.copy(factory, node));
    }

    public void visitInboundFeatureNode(FeatureNode node) {
        if (this.getStrategy().isInFilter(node)) {
            this.copy(this.getFilterFactory(), node).addDependency(this.getCurrentNode());
        }
    }

    public void visitOutboundFeatureNode(FeatureNode node) {
        if (this.getStrategy().isInFilter(node)) {
            this.getCurrentNode().addDependency(this.copy(this.getFilterFactory(), node));
        }
    }

    protected PackageNode copy(NodeFactory factory, PackageNode node) {
        return factory.createPackage(node.getName(), node.isConfirmed());
    }

    protected ClassNode copy(NodeFactory factory, ClassNode node) {
        this.copy(factory, node.getPackageNode());
        return factory.createClass(node.getName(), node.isConfirmed());
    }

    protected FeatureNode copy(NodeFactory factory, FeatureNode node) {
        this.copy(factory, node.getClassNode());
        return factory.createFeature(node.getName(), node.isConfirmed());
    }
}

