/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.SelectionCriteria;
import com.jeantessier.dependency.Visitor;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureStopSelector
implements Visitor {
    private boolean done = false;
    private SelectionCriteria criteria;

    public ClosureStopSelector(SelectionCriteria criteria) {
        this.criteria = criteria;
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    public void traverseNodes(Collection<? extends Node> nodes) {
        if (nodes.isEmpty()) {
            this.done = true;
        } else {
            for (Node node : nodes) {
                node.accept(this);
            }
        }
    }

    @Override
    public void visitPackageNode(PackageNode node) {
        if (this.criteria.matches(node)) {
            this.done = true;
        }
    }

    @Override
    public void visitInboundPackageNode(PackageNode node) {
    }

    @Override
    public void visitOutboundPackageNode(PackageNode node) {
    }

    @Override
    public void visitClassNode(ClassNode node) {
        if (this.criteria.matches(node)) {
            this.done = true;
        }
    }

    @Override
    public void visitInboundClassNode(ClassNode node) {
    }

    @Override
    public void visitOutboundClassNode(ClassNode node) {
    }

    @Override
    public void visitFeatureNode(FeatureNode node) {
        if (this.criteria.matches(node)) {
            this.done = true;
        }
    }

    @Override
    public void visitInboundFeatureNode(FeatureNode node) {
    }

    @Override
    public void visitOutboundFeatureNode(FeatureNode node) {
    }
}

