/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.ClosureSelector;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.SelectionCriteria;

public class ClosureStartSelector
extends ClosureSelector {
    private SelectionCriteria criteria;

    public ClosureStartSelector(NodeFactory factory, SelectionCriteria criteria) {
        super(factory);
        this.criteria = criteria;
    }

    public void visitPackageNode(PackageNode node) {
        if (this.criteria.matches(node)) {
            this.getSelectedNodes().add(node);
            this.getCopiedNodes().add(this.getFactory().createPackage(node.getName(), node.isConfirmed()));
        }
        this.traverseNodes(node.getClasses());
    }

    public void visitInboundPackageNode(PackageNode node) {
    }

    public void visitOutboundPackageNode(PackageNode node) {
    }

    public void visitClassNode(ClassNode node) {
        if (this.criteria.matches(node)) {
            this.getSelectedNodes().add(node);
            this.getCopiedNodes().add(this.getFactory().createClass(node.getName(), node.isConfirmed()));
        }
        this.traverseNodes(node.getFeatures());
    }

    public void visitInboundClassNode(ClassNode node) {
    }

    public void visitOutboundClassNode(ClassNode node) {
    }

    public void visitFeatureNode(FeatureNode node) {
        if (this.criteria.matches(node)) {
            this.getSelectedNodes().add(node);
            this.getCopiedNodes().add(this.getFactory().createFeature(node.getName(), node.isConfirmed()));
        }
    }

    public void visitInboundFeatureNode(FeatureNode node) {
    }

    public void visitOutboundFeatureNode(FeatureNode node) {
    }
}

