/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.Visitor;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClosureSelector
implements Visitor {
    private Collection<Node> selectedNodes;
    private Collection<Node> copiedNodes;
    private NodeFactory factory;

    public ClosureSelector() {
        this.reset();
    }

    public ClosureSelector(NodeFactory factory) {
        this();
        this.setFactory(factory);
    }

    public void reset() {
        this.selectedNodes = new HashSet<Node>();
        this.copiedNodes = new HashSet<Node>();
    }

    public NodeFactory getFactory() {
        return this.factory;
    }

    public void setFactory(NodeFactory factory) {
        this.factory = factory;
    }

    public Collection<Node> getSelectedNodes() {
        return this.selectedNodes;
    }

    public Collection<Node> getCopiedNodes() {
        return this.copiedNodes;
    }

    @Override
    public void traverseNodes(Collection<? extends Node> nodes) {
        for (Node node : nodes) {
            node.accept(this);
        }
    }

    protected void traverseInbound(Collection<? extends Node> nodes) {
        for (Node node : nodes) {
            node.acceptInbound(this);
        }
    }

    protected void traverseOutbound(Collection<? extends Node> nodes) {
        for (Node node : nodes) {
            node.acceptOutbound(this);
        }
    }
}

