/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.ClosureSelector;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.PackageNode;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClosureLayerSelector
extends ClosureSelector {
    private Node currentNode;
    private Collection<? extends Node> coverage;

    public ClosureLayerSelector() {
    }

    public ClosureLayerSelector(NodeFactory factory, Collection<? extends Node> coverage) {
        super(factory);
        this.setCoverage(coverage);
    }

    @Override
    public void reset() {
        super.reset();
        this.currentNode = null;
    }

    public Collection<? extends Node> getCoverage() {
        return this.coverage;
    }

    public void setCoverage(Collection<? extends Node> coverage) {
        this.coverage = coverage;
    }

    @Override
    public void visitPackageNode(PackageNode node) {
        this.currentNode = this.getFactory().createPackage(node.getName(), node.isConfirmed());
    }

    @Override
    public void visitInboundPackageNode(PackageNode node) {
        if (!this.getCoverage().contains(node)) {
            this.getSelectedNodes().add(node);
            PackageNode copy = this.getFactory().createPackage(node.getName(), node.isConfirmed());
            this.getCopiedNodes().add(copy);
            copy.addDependency(this.currentNode);
        }
    }

    @Override
    public void visitOutboundPackageNode(PackageNode node) {
        if (!this.getCoverage().contains(node)) {
            this.getSelectedNodes().add(node);
            PackageNode copy = this.getFactory().createPackage(node.getName(), node.isConfirmed());
            this.getCopiedNodes().add(copy);
            this.currentNode.addDependency(copy);
        }
    }

    @Override
    public void visitClassNode(ClassNode node) {
        this.currentNode = this.getFactory().createClass(node.getName(), node.isConfirmed());
    }

    @Override
    public void visitInboundClassNode(ClassNode node) {
        if (!this.getCoverage().contains(node)) {
            this.getSelectedNodes().add(node);
            ClassNode copy = this.getFactory().createClass(node.getName(), node.isConfirmed());
            this.getCopiedNodes().add(copy);
            copy.addDependency(this.currentNode);
        }
    }

    @Override
    public void visitOutboundClassNode(ClassNode node) {
        if (!this.getCoverage().contains(node)) {
            this.getSelectedNodes().add(node);
            ClassNode copy = this.getFactory().createClass(node.getName(), node.isConfirmed());
            this.getCopiedNodes().add(copy);
            this.currentNode.addDependency(copy);
        }
    }

    @Override
    public void visitFeatureNode(FeatureNode node) {
        this.currentNode = this.getFactory().createFeature(node.getName(), node.isConfirmed());
    }

    @Override
    public void visitInboundFeatureNode(FeatureNode node) {
        if (!this.getCoverage().contains(node)) {
            this.getSelectedNodes().add(node);
            FeatureNode copy = this.getFactory().createFeature(node.getName(), node.isConfirmed());
            this.getCopiedNodes().add(copy);
            copy.addDependency(this.currentNode);
        }
    }

    @Override
    public void visitOutboundFeatureNode(FeatureNode node) {
        if (!this.getCoverage().contains(node)) {
            this.getSelectedNodes().add(node);
            FeatureNode copy = this.getFactory().createFeature(node.getName(), node.isConfirmed());
            this.getCopiedNodes().add(copy);
            this.currentNode.addDependency(copy);
        }
    }
}

