/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.Visitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNode
extends Node {
    private PackageNode parent;
    private Collection<FeatureNode> features = new HashSet<FeatureNode>();

    public ClassNode(PackageNode parent, String name, boolean concrete) {
        super(name, concrete);
        this.parent = parent;
    }

    public String getSimpleName() {
        return this.getName().substring(this.getName().lastIndexOf(46) + 1);
    }

    @Override
    void setConfirmed(boolean confirmed) {
        if (!confirmed) {
            for (FeatureNode featureNode : this.getFeatures()) {
                featureNode.setConfirmed(false);
            }
        }
        super.setConfirmed(confirmed);
        this.getPackageNode().setConfirmed(confirmed);
    }

    public PackageNode getPackageNode() {
        return this.parent;
    }

    public void addFeature(FeatureNode node) {
        this.features.add(node);
    }

    public void removeFeature(FeatureNode node) {
        this.features.remove(node);
    }

    public Collection<FeatureNode> getFeatures() {
        return Collections.unmodifiableCollection(this.features);
    }

    @Override
    public boolean canAddDependencyTo(Node node) {
        return super.canAddDependencyTo(node) && this.getPackageNode().canAddDependencyTo(node);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitClassNode(this);
    }

    @Override
    public void acceptInbound(Visitor visitor) {
        visitor.visitInboundClassNode(this);
    }

    @Override
    public void acceptOutbound(Visitor visitor) {
        visitor.visitOutboundClassNode(this);
    }
}

