/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.commandline;

import com.jeantessier.commandline.AliasSwitch;
import com.jeantessier.commandline.AtLeastParameterStrategy;
import com.jeantessier.commandline.AtMostParameterStrategy;
import com.jeantessier.commandline.CollectingParameterStrategy;
import com.jeantessier.commandline.CommandLine;
import com.jeantessier.commandline.ExactlyParameterStrategy;
import com.jeantessier.commandline.MultipleValuesSwitch;
import com.jeantessier.commandline.NullParameterStrategy;
import com.jeantessier.commandline.OptionalValueSwitch;
import com.jeantessier.commandline.ParameterStrategy;
import com.jeantessier.commandline.Printer;
import com.jeantessier.commandline.SingleValueSwitch;
import com.jeantessier.commandline.ToggleSwitch;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextPrinter
extends Printer {
    public TextPrinter(String command) {
        this.append(command).eol();
    }

    @Override
    protected Set<String> getSwitchNames(CommandLine commandLine) {
        return commandLine.getPresentSwitches();
    }

    @Override
    public void visitToggleSwitch(ToggleSwitch cls) {
        this.indent().append("-").append(cls.getName()).eol();
    }

    @Override
    public void visitSingleValueSwitch(SingleValueSwitch cls) {
        this.indent().append("-").append(cls.getName()).append(" ").append(cls.getValue()).eol();
    }

    @Override
    public void visitOptionalValueSwitch(OptionalValueSwitch cls) {
        this.indent().append("-").append(cls.getName());
        if (!"".equals(cls.getValue())) {
            this.append(" ").append(cls.getValue());
        }
        this.eol();
    }

    @Override
    public void visitMultipleValuesSwitch(MultipleValuesSwitch cls) {
        for (String value : (List)cls.getValue()) {
            this.indent().append("-").append(cls.getName()).append(" ").append(value).eol();
        }
    }

    @Override
    public void visitAliasSwitch(AliasSwitch cls) {
    }

    @Override
    public void visitNullParameterStrategy(NullParameterStrategy strategy) {
        this.visitParameterStrategy(strategy);
    }

    @Override
    public void visitCollectingParameterStrategy(CollectingParameterStrategy strategy) {
        this.visitParameterStrategy(strategy);
    }

    @Override
    public void visitAtLeastParameterStrategy(AtLeastParameterStrategy strategy) {
        this.visitParameterStrategy(strategy);
    }

    @Override
    public void visitExactlyParameterStrategy(ExactlyParameterStrategy strategy) {
        this.visitParameterStrategy(strategy);
    }

    @Override
    public void visitAtMostParameterStrategy(AtMostParameterStrategy strategy) {
        this.visitParameterStrategy(strategy);
    }

    private void visitParameterStrategy(ParameterStrategy strategy) {
        for (String value : strategy.getParameters()) {
            this.indent().append(value).eol();
        }
    }
}

