/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.commandline;

import com.jeantessier.commandline.AliasSwitch;
import com.jeantessier.commandline.CollectingParameterStrategy;
import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.commandline.CommandLineSwitch;
import com.jeantessier.commandline.MultipleValuesSwitch;
import com.jeantessier.commandline.OptionalValueSwitch;
import com.jeantessier.commandline.ParameterStrategy;
import com.jeantessier.commandline.SingleValueSwitch;
import com.jeantessier.commandline.ToggleSwitch;
import com.jeantessier.commandline.Visitable;
import com.jeantessier.commandline.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLine
implements Visitable {
    private static final boolean DEFAULT_STRICT = true;
    private boolean strict;
    private ParameterStrategy parameterStrategy;
    private Map<String, CommandLineSwitch> map = new TreeMap<String, CommandLineSwitch>();

    public CommandLine() {
        this(true, new CollectingParameterStrategy());
    }

    public CommandLine(boolean strict) {
        this(strict, new CollectingParameterStrategy());
    }

    public CommandLine(ParameterStrategy parameterStrategy) {
        this(true, parameterStrategy);
    }

    public CommandLine(boolean strict, ParameterStrategy parameterStrategy) {
        this.setStrict(strict);
        this.setParameterStrategy(parameterStrategy);
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public ParameterStrategy getParameterStrategy() {
        return this.parameterStrategy;
    }

    public void setParameterStrategy(ParameterStrategy parameterStrategy) {
        this.parameterStrategy = parameterStrategy;
    }

    public ToggleSwitch addToggleSwitch(String name) {
        return this.addSwitch(new ToggleSwitch(name));
    }

    public ToggleSwitch addToggleSwitch(String name, boolean defaultValue) {
        return this.addSwitch(new ToggleSwitch(name, defaultValue));
    }

    public SingleValueSwitch addSingleValueSwitch(String name) {
        return this.addSwitch(new SingleValueSwitch(name));
    }

    public SingleValueSwitch addSingleValueSwitch(String name, boolean mandatory) {
        return this.addSwitch(new SingleValueSwitch(name, mandatory));
    }

    public SingleValueSwitch addSingleValueSwitch(String name, String defaultValue) {
        return this.addSwitch(new SingleValueSwitch(name, defaultValue));
    }

    public SingleValueSwitch addSingleValueSwitch(String name, String defaultValue, boolean mandatory) {
        return this.addSwitch(new SingleValueSwitch(name, defaultValue, mandatory));
    }

    public OptionalValueSwitch addOptionalValueSwitch(String name) {
        return this.addSwitch(new OptionalValueSwitch(name));
    }

    public OptionalValueSwitch addOptionalValueSwitch(String name, boolean mandatory) {
        return this.addSwitch(new OptionalValueSwitch(name, mandatory));
    }

    public OptionalValueSwitch addOptionalValueSwitch(String name, String defaultValue) {
        return this.addSwitch(new OptionalValueSwitch(name, defaultValue));
    }

    public OptionalValueSwitch addOptionalValueSwitch(String name, String defaultValue, boolean mandatory) {
        return this.addSwitch(new OptionalValueSwitch(name, defaultValue, mandatory));
    }

    public MultipleValuesSwitch addMultipleValuesSwitch(String name) {
        return this.addSwitch(new MultipleValuesSwitch(name));
    }

    public MultipleValuesSwitch addMultipleValuesSwitch(String name, boolean mandatory) {
        return this.addSwitch(new MultipleValuesSwitch(name, mandatory));
    }

    public MultipleValuesSwitch addMultipleValuesSwitch(String name, String defaultValue) {
        return this.addSwitch(new MultipleValuesSwitch(name, defaultValue));
    }

    public MultipleValuesSwitch addMultipleValuesSwitch(String name, String defaultValue, boolean mandatory) {
        return this.addSwitch(new MultipleValuesSwitch(name, defaultValue, mandatory));
    }

    public AliasSwitch addAliasSwitch(String name, String ... switchNames) {
        CommandLineSwitch[] switches = new CommandLineSwitch[switchNames.length];
        for (int i = 0; i < switchNames.length; ++i) {
            switches[i] = this.getSwitch(switchNames[i], true);
        }
        return this.addSwitch(new AliasSwitch(name, switches));
    }

    private <T extends CommandLineSwitch> T addSwitch(T cls) {
        this.map.put(cls.getName(), cls);
        return cls;
    }

    public CommandLineSwitch getSwitch(String name) {
        return this.getSwitch(name, this.isStrict());
    }

    public CommandLineSwitch getSwitch(String name, boolean strict) {
        CommandLineSwitch cls = this.map.get(name);
        if (cls == null) {
            if (strict) {
                throw new IllegalArgumentException("Unknown switch \"" + name + "\"");
            }
            cls = new OptionalValueSwitch(name);
            this.addSwitch(cls);
        }
        return cls;
    }

    public boolean getToggleSwitch(String name) {
        boolean result = false;
        CommandLineSwitch cls = this.map.get(name);
        if (cls != null) {
            result = (Boolean)cls.getValue();
        }
        return result;
    }

    public String getSingleSwitch(String name) {
        return this.getStringSwitch(name);
    }

    public String getOptionalSwitch(String name) {
        return this.getStringSwitch(name);
    }

    public List<String> getMultipleSwitch(String name) {
        return this.getListSwitch(name);
    }

    private String getStringSwitch(String name) {
        String result = null;
        CommandLineSwitch cls = this.map.get(name);
        if (cls != null) {
            result = cls.getValue().toString();
        }
        return result;
    }

    private List<String> getListSwitch(String name) {
        List result = null;
        CommandLineSwitch cls = this.map.get(name);
        if (cls != null && cls.getValue() instanceof List) {
            result = (List)cls.getValue();
        }
        return result;
    }

    public boolean isPresent(String name) {
        boolean result = false;
        CommandLineSwitch cls = this.map.get(name);
        if (cls != null) {
            result = cls.isPresent();
        }
        return result;
    }

    public Set<String> getKnownSwitches() {
        return this.map.keySet();
    }

    public Collection<CommandLineSwitch> getSwitches() {
        return this.map.values();
    }

    public Set<String> getPresentSwitches() {
        TreeSet<String> result = new TreeSet<String>();
        for (String name : this.getKnownSwitches()) {
            CommandLineSwitch cls = this.map.get(name);
            if (!cls.isPresent()) continue;
            result.add(name);
        }
        return result;
    }

    public List<String> getParameters() {
        return this.parameterStrategy.getParameters();
    }

    public Collection<CommandLineException> parse(String[] args) {
        ArrayList<CommandLineException> exceptions = new ArrayList<CommandLineException>();
        int i = 0;
        while (i < args.length) {
            try {
                if (args[i].startsWith("-")) {
                    String name = args[i].substring(1);
                    String value = null;
                    if (i + 1 < args.length && !this.map.containsKey(args[i + 1].substring(1))) {
                        value = args[i + 1];
                    }
                    i += this.getSwitch(name).parse(value);
                    continue;
                }
                i += this.parameterStrategy.accept(args[i]);
            }
            catch (CommandLineException e) {
                exceptions.add(e);
            }
        }
        for (CommandLineSwitch cls : this.map.values()) {
            try {
                cls.validate();
            }
            catch (CommandLineException e) {
                exceptions.add(e);
            }
        }
        try {
            this.parameterStrategy.validate();
        }
        catch (CommandLineException e) {
            exceptions.add(e);
        }
        return exceptions;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitCommandLine(this);
    }
}

