/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.commandline;

import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.commandline.LimitedCollectingParameterStrategy;
import com.jeantessier.commandline.Visitor;

public class AtMostParameterStrategy
extends LimitedCollectingParameterStrategy {
    public AtMostParameterStrategy(int limit) {
        super(limit);
    }

    public int accept(String param) throws CommandLineException {
        if (this.getParameters().size() < this.getLimit()) {
            return super.accept(param);
        }
        throw new CommandLineException("Exceeding " + this.getLimit() + " parameter(s).");
    }

    public void validate() throws CommandLineException {
        if (this.getParameters().size() > this.getLimit()) {
            throw new CommandLineException("Number of parameters (" + this.getParameters().size() + ") cannot exceed " + this.getLimit());
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitAtMostParameterStrategy(this);
    }
}

