/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.ClassfileLoaderDecorator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;

public class ZipClassfileLoader
extends ClassfileLoaderDecorator {
    private static final int BUFFER_SIZE = 16384;

    public ZipClassfileLoader(ClassfileLoader loader) {
        super(loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(String filename) {
        Logger.getLogger(this.getClass()).debug((Object)("Starting group in file " + filename));
        ZipFile zipfile = null;
        try {
            zipfile = new ZipFile(filename);
            this.fireBeginGroup(filename, zipfile.size());
            Logger.getLogger(this.getClass()).debug((Object)("Loading ZipFile " + filename));
            this.load(zipfile);
            Logger.getLogger(this.getClass()).debug((Object)("Loaded ZipFile " + filename));
            this.fireEndGroup(filename);
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass()).error((Object)("Cannot load Zip file \"" + filename + "\""), (Throwable)ex);
        }
        finally {
            if (zipfile != null) {
                try {
                    zipfile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(String filename, InputStream in) {
        Logger.getLogger(this.getClass()).debug((Object)("Starting group in stream " + filename));
        ZipInputStream zipfile = null;
        try {
            zipfile = new ZipInputStream(in);
            this.fireBeginGroup(filename, -1);
            Logger.getLogger(this.getClass()).debug((Object)("Loading ZipInputStream " + filename));
            this.load(zipfile);
            Logger.getLogger(this.getClass()).debug((Object)("Loaded ZipInputStream " + filename));
            this.fireEndGroup(filename);
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass()).error((Object)("Cannot load Zip file \"" + filename + "\""), (Throwable)ex);
        }
        finally {
            if (zipfile != null) {
                try {
                    zipfile.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(ZipFile zipfile) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipfile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            this.fireBeginFile(entry.getName());
            Logger.getLogger(this.getClass()).debug((Object)("Starting file " + entry.getName() + " (" + entry.getSize() + " bytes)"));
            byte[] bytes = null;
            InputStream in = null;
            try {
                in = zipfile.getInputStream(entry);
                bytes = this.readBytes(in);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {}
                }
            }
            Logger.getLogger(this.getClass()).debug((Object)("Passing up file " + entry.getName() + " (" + bytes.length + " bytes)"));
            this.getLoader().load(entry.getName(), new ByteArrayInputStream(bytes));
            this.fireEndFile(entry.getName());
        }
    }

    protected void load(ZipInputStream in) throws IOException {
        ZipEntry entry;
        while ((entry = in.getNextEntry()) != null) {
            this.fireBeginFile(entry.getName());
            Logger.getLogger(this.getClass()).debug((Object)("Starting file " + entry.getName() + " (" + entry.getSize() + " bytes)"));
            byte[] bytes = this.readBytes(in);
            Logger.getLogger(this.getClass()).debug((Object)("Passing up file " + entry.getName() + " (" + bytes.length + " bytes)"));
            this.getLoader().load(entry.getName(), new ByteArrayInputStream(bytes));
            this.fireEndFile(entry.getName());
        }
    }

    private byte[] readBytes(InputStream in) {
        byte[] result = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[16384];
            int bytesRead = 0;
            while ((bytesRead = in.read(buffer, 0, 16384)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.close();
            result = out.toByteArray();
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass()).debug((Object)"Error loading Zip entry", (Throwable)ex);
        }
        return result;
    }
}

