/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Attribute_info;
import com.jeantessier.classreader.BitFormat;
import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Code_attribute;
import com.jeantessier.classreader.ConstantPool;
import com.jeantessier.classreader.ConstantPoolEntry;
import com.jeantessier.classreader.ConstantValue_attribute;
import com.jeantessier.classreader.Deprecated_attribute;
import com.jeantessier.classreader.Double_info;
import com.jeantessier.classreader.ExceptionHandler;
import com.jeantessier.classreader.Exceptions_attribute;
import com.jeantessier.classreader.FieldRef_info;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.Float_info;
import com.jeantessier.classreader.InnerClass;
import com.jeantessier.classreader.InnerClasses_attribute;
import com.jeantessier.classreader.Instruction;
import com.jeantessier.classreader.Integer_info;
import com.jeantessier.classreader.InterfaceMethodRef_info;
import com.jeantessier.classreader.LineNumber;
import com.jeantessier.classreader.LineNumberTable_attribute;
import com.jeantessier.classreader.LocalVariable;
import com.jeantessier.classreader.LocalVariableTable_attribute;
import com.jeantessier.classreader.Long_info;
import com.jeantessier.classreader.MethodRef_info;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.classreader.NameAndType_info;
import com.jeantessier.classreader.Printer;
import com.jeantessier.classreader.SignatureHelper;
import com.jeantessier.classreader.SourceFile_attribute;
import com.jeantessier.classreader.String_info;
import com.jeantessier.classreader.Synthetic_attribute;
import com.jeantessier.classreader.UTF8_info;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import org.apache.oro.text.perl.Perl5Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPrinter
extends Printer {
    public static final String DEFAULT_ENCODING = "utf-8";
    public static final String DEFAULT_DTD_PREFIX = "http://depfind.sourceforge.net/dtd";
    private static final BitFormat format = new BitFormat(16);
    private static final Perl5Util perl = new Perl5Util();
    private boolean top = true;

    public XMLPrinter(PrintWriter out) {
        this(out, DEFAULT_ENCODING, DEFAULT_DTD_PREFIX);
    }

    public XMLPrinter(PrintWriter out, String encoding, String dtdPrefix) {
        super(out);
        this.appendHeader(encoding, dtdPrefix);
    }

    private void appendHeader(String encoding, String dtdPrefix) {
        this.append("<?xml version=\"1.0\" encoding=\"").append(encoding).append("\" ?>").eol();
        this.eol();
        this.append("<!DOCTYPE classfiles SYSTEM \"").append(dtdPrefix).append("/classfile.dtd\">").eol();
        this.eol();
    }

    @Override
    public void visitClassfiles(Collection<Classfile> classfiles) {
        this.indent().append("<classfiles>").eol();
        this.raiseIndent();
        super.visitClassfiles(classfiles);
        this.lowerIndent();
        this.indent().append("</classfiles>").eol();
    }

    @Override
    public void visitClassfile(Classfile classfile) {
        this.indent().append("<classfile magic-number=\"").append(classfile.getMagicNumber()).append("\" minor-version=\"").append(classfile.getMinorVersion()).append("\" major-version=\"").append(classfile.getMajorVersion()).append("\" access-flag=\"").append(format.format(classfile.getAccessFlag())).append("\">").eol();
        this.raiseIndent();
        this.top = true;
        classfile.getConstantPool().accept(this);
        this.top = false;
        if (classfile.isPublic()) {
            this.indent().append("<public/>").eol();
        }
        if (classfile.isFinal()) {
            this.indent().append("<final/>").eol();
        }
        if (classfile.isSuper()) {
            this.indent().append("<super/>").eol();
        }
        if (classfile.isInterface()) {
            this.indent().append("<is-interface/>").eol();
        }
        if (classfile.isAbstract()) {
            this.indent().append("<abstract/>").eol();
        }
        this.indent();
        this.append("<this-class>");
        classfile.getRawClass().accept(this);
        this.append("</this-class>").eol();
        this.indent();
        this.append("<superclass>");
        if (classfile.getSuperclassIndex() != 0) {
            classfile.getRawSuperclass().accept(this);
        }
        this.append("</superclass>").eol();
        if (!classfile.getAllInterfaces().isEmpty()) {
            this.indent().append("<interfaces>").eol();
            this.raiseIndent();
            for (Class_info class_info : classfile.getAllInterfaces()) {
                this.indent();
                this.append("<interface>");
                class_info.accept(this);
                this.append("</interface>").eol();
            }
            this.lowerIndent();
            this.indent().append("</interfaces>").eol();
        }
        if (!classfile.getAllFields().isEmpty()) {
            this.indent().append("<fields>").eol();
            this.raiseIndent();
            for (Field_info field : classfile.getAllFields()) {
                field.accept(this);
            }
            this.lowerIndent();
            this.indent().append("</fields>").eol();
        }
        if (!classfile.getAllMethods().isEmpty()) {
            this.indent().append("<methods>").eol();
            this.raiseIndent();
            for (Method_info method : classfile.getAllMethods()) {
                method.accept(this);
            }
            this.lowerIndent();
            this.indent().append("</methods>").eol();
        }
        if (!classfile.getAttributes().isEmpty()) {
            this.indent().append("<attributes>").eol();
            this.raiseIndent();
            for (Attribute_info attribute : classfile.getAttributes()) {
                attribute.accept(this);
            }
            this.lowerIndent();
            this.indent().append("</attributes>").eol();
        }
        this.lowerIndent();
        this.indent().append("</classfile>").eol();
    }

    @Override
    public void visitConstantPool(ConstantPool constantPool) {
        this.resetCount();
        this.indent().append("<constant-pool>").eol();
        this.raiseIndent();
        for (ConstantPoolEntry entry : constantPool) {
            if (entry != null) {
                entry.accept(this);
            }
            this.incrementCount();
        }
        this.lowerIndent();
        this.indent().append("</constant-pool>").eol();
    }

    @Override
    public void visitClass_info(Class_info entry) {
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<class id=\"").append(this.currentCount()).append("\">");
            this.append(entry.getName());
            this.append("</class>").eol();
            this.top = true;
        } else {
            this.append(entry.getName());
        }
    }

    @Override
    public void visitFieldRef_info(FieldRef_info entry) {
        Class_info c = entry.getRawClass();
        NameAndType_info nat = entry.getRawNameAndType();
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<field-ref-info id=\"").append(this.currentCount()).append("\">");
            this.append("<class>");
            c.accept(this);
            this.append("</class>");
            this.append("<type>");
            nat.getRawType().accept(this);
            this.append("</type>");
            this.append("<name>");
            nat.getRawName().accept(this);
            this.append("</name>");
            this.append("</field-ref-info>").eol();
            this.top = true;
        } else {
            this.append(SignatureHelper.getType(nat.getType()));
            this.append(" ");
            this.append(entry.getFullSignature());
        }
    }

    @Override
    public void visitMethodRef_info(MethodRef_info entry) {
        Class_info c = entry.getRawClass();
        NameAndType_info nat = entry.getRawNameAndType();
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<method-ref-info id=\"").append(this.currentCount()).append("\">");
            this.append("<class>");
            c.accept(this);
            this.append("</class>");
            this.append("<name>");
            nat.getRawName().accept(this);
            this.append("</name>");
            this.append("<type>");
            nat.getRawType().accept(this);
            this.append("</type>");
            this.append("</method-ref-info>").eol();
            this.top = true;
        } else {
            if (!entry.isConstructor() && !entry.isStaticInitializer()) {
                this.append(SignatureHelper.getReturnType(nat.getType())).append(" ");
            }
            this.append(entry.getFullSignature());
        }
    }

    @Override
    public void visitInterfaceMethodRef_info(InterfaceMethodRef_info entry) {
        Class_info c = entry.getRawClass();
        NameAndType_info nat = entry.getRawNameAndType();
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<interface-method-ref-info id=\"").append(this.currentCount()).append("\">");
            this.append("<class>");
            c.accept(this);
            this.append("</class>");
            this.append("<name>");
            nat.getRawName().accept(this);
            this.append("</name>");
            this.append("<type>");
            nat.getRawType().accept(this);
            this.append("</type>");
            this.append("</interface-method-ref-info>").eol();
            this.top = true;
        } else {
            this.append(SignatureHelper.getReturnType(nat.getType()));
            this.append(" ");
            this.append(entry.getFullSignature());
        }
    }

    @Override
    public void visitString_info(String_info entry) {
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<string-info id=\"").append(this.currentCount()).append("\">");
            entry.getRawValue().accept(this);
            this.append("</string-info>").eol();
            this.top = true;
        } else {
            entry.getRawValue().accept(this);
        }
    }

    @Override
    public void visitInteger_info(Integer_info entry) {
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<integer-info id=\"").append(this.currentCount()).append("\">");
            this.append(entry.getValue());
            this.append("</integer-info>").eol();
            this.top = true;
        } else {
            this.append(entry.getValue());
        }
    }

    @Override
    public void visitFloat_info(Float_info entry) {
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<float-info id=\"").append(this.currentCount()).append("\">");
            this.append(entry.getValue());
            this.append("</float-info>").eol();
            this.top = true;
        } else {
            this.append(entry.getValue());
        }
    }

    @Override
    public void visitLong_info(Long_info entry) {
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<long-info id=\"").append(this.currentCount()).append("\">");
            this.append(entry.getValue());
            this.append("</long-info>").eol();
            this.top = true;
        } else {
            this.append(entry.getValue());
        }
    }

    @Override
    public void visitDouble_info(Double_info entry) {
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<double-info id=\"").append(this.currentCount()).append("\">");
            this.append(entry.getValue());
            this.append("</double-info>").eol();
            this.top = true;
        } else {
            this.append(entry.getValue());
        }
    }

    @Override
    public void visitNameAndType_info(NameAndType_info entry) {
        if (this.top) {
            this.top = false;
            this.indent();
            this.append("<name-and-type-info id=\"").append(this.currentCount()).append("\">");
            this.append("<name>");
            entry.getRawName().accept(this);
            this.append("</name>");
            this.append("<type>");
            entry.getRawType().accept(this);
            this.append("</type>");
            this.append("</name-and-type-info>").eol();
            this.top = true;
        } else {
            entry.getRawName().accept(this);
            this.append(" ");
            entry.getRawType().accept(this);
        }
    }

    @Override
    public void visitUTF8_info(UTF8_info entry) {
        if (this.top) {
            this.top = false;
            this.indent().append("<utf8-info id=\"").append(this.currentCount()).append("\">");
            this.append(this.escapeXMLCharacters(entry.getValue()));
            this.append("</utf8-info>").eol();
            this.top = true;
        } else {
            this.append(this.escapeXMLCharacters(entry.getValue()));
        }
    }

    @Override
    public void visitField_info(Field_info entry) {
        this.indent().append("<field-info access-flag=\"").append(format.format(entry.getAccessFlag())).append("\">").eol();
        this.raiseIndent();
        if (entry.isPublic()) {
            this.indent().append("<public/>").eol();
        }
        if (entry.isProtected()) {
            this.indent().append("<protected/>").eol();
        }
        if (entry.isPrivate()) {
            this.indent().append("<private/>").eol();
        }
        if (entry.isStatic()) {
            this.indent().append("<static/>").eol();
        }
        if (entry.isFinal()) {
            this.indent().append("<final/>").eol();
        }
        if (entry.isVolatile()) {
            this.indent().append("<volatile/>").eol();
        }
        if (entry.isTransient()) {
            this.indent().append("<transient/>").eol();
        }
        this.indent();
        this.append("<name>");
        entry.getRawName().accept(this);
        this.append("</name>").eol();
        this.indent().append("<type>").append(entry.getType()).append("</type>").eol();
        if (!entry.getAttributes().isEmpty()) {
            this.indent().append("<attributes>").eol();
            this.raiseIndent();
            super.visitField_info(entry);
            this.lowerIndent();
            this.indent().append("</attributes>").eol();
        }
        this.lowerIndent();
        this.indent().append("</field-info>").eol();
    }

    @Override
    public void visitMethod_info(Method_info entry) {
        this.indent().append("<method-info access-flag=\"").append(format.format(entry.getAccessFlag())).append("\">").eol();
        this.raiseIndent();
        if (entry.isPublic()) {
            this.indent().append("<public/>").eol();
        }
        if (entry.isProtected()) {
            this.indent().append("<protected/>").eol();
        }
        if (entry.isPrivate()) {
            this.indent().append("<private/>").eol();
        }
        if (entry.isStatic()) {
            this.indent().append("<static/>").eol();
        }
        if (entry.isFinal()) {
            this.indent().append("<final/>").eol();
        }
        if (entry.isSynchronized()) {
            this.indent().append("<synchronized/>").eol();
        }
        if (entry.isNative()) {
            this.indent().append("<native/>").eol();
        }
        if (entry.isAbstract()) {
            this.indent().append("<abstract/>").eol();
        }
        if (entry.isStrict()) {
            this.indent().append("<strict/>").eol();
        }
        this.indent();
        this.append("<name>");
        entry.getRawName().accept(this);
        this.append("</name>").eol();
        if (!entry.getName().equals("<init>") && !entry.getName().equals("<clinit>")) {
            this.indent().append("<return-type>").append(entry.getReturnType() != null ? entry.getReturnType() : "void").append("</return-type>").eol();
        }
        this.indent().append("<signature>").append(entry.getSignature()).append("</signature>").eol();
        if (!entry.getAttributes().isEmpty()) {
            this.indent().append("<attributes>").eol();
            this.raiseIndent();
            super.visitMethod_info(entry);
            this.lowerIndent();
            this.indent().append("</attributes>").eol();
        }
        this.lowerIndent();
        this.indent().append("</method-info>").eol();
    }

    @Override
    public void visitConstantValue_attribute(ConstantValue_attribute attribute) {
        this.indent().append("<constant-value-attribute>");
        attribute.getRawValue().accept(this);
        this.append("</constant-value-attribute>").eol();
    }

    @Override
    public void visitCode_attribute(Code_attribute attribute) {
        this.indent().append("<code-attribute>").eol();
        this.raiseIndent();
        this.indent().append("<length>").append(attribute.getCode().length).append("</length>").eol();
        this.indent().append("<instructions>").eol();
        this.raiseIndent();
        Iterator i = attribute.iterator();
        while (i.hasNext()) {
            Instruction instr = (Instruction)i.next();
            this.indent();
            this.append("<instruction pc=\"").append(instr.getStart()).append("\" length=\"").append(instr.getLength()).append("\"");
            switch (instr.getOpcode()) {
                case 18: 
                case 19: 
                case 20: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 185: 
                case 187: 
                case 189: 
                case 192: 
                case 193: 
                case 197: {
                    this.append(" index=\"").append(instr.getIndex()).append("\">");
                    this.append(instr);
                    this.append(" ");
                    instr.getIndexedConstantPoolEntry().accept(this);
                    break;
                }
                default: {
                    this.append(">");
                    this.append(instr);
                }
            }
            this.append("</instruction>").eol();
        }
        this.lowerIndent();
        this.indent().append("</instructions>").eol();
        if (!attribute.getExceptionHandlers().isEmpty()) {
            this.indent().append("<exception-handlers>").eol();
            this.raiseIndent();
            for (ExceptionHandler exceptionHandler : attribute.getExceptionHandlers()) {
                exceptionHandler.accept(this);
            }
            this.lowerIndent();
            this.indent().append("</exception-handlers>").eol();
        }
        if (!attribute.getAttributes().isEmpty()) {
            this.indent().append("<attributes>").eol();
            this.raiseIndent();
            for (Attribute_info attribute_info : attribute.getAttributes()) {
                attribute_info.accept(this);
            }
            this.lowerIndent();
            this.indent().append("</attributes>").eol();
        }
        this.lowerIndent();
        this.indent().append("</code-attribute>").eol();
    }

    @Override
    public void visitExceptions_attribute(Exceptions_attribute attribute) {
        this.indent().append("<exceptions-attribute>").eol();
        this.raiseIndent();
        for (Class_info exception : attribute.getExceptions()) {
            this.indent();
            this.append("<exception>");
            exception.accept(this);
            this.append("</exception>").eol();
        }
        this.lowerIndent();
        this.indent().append("</exceptions-attribute>").eol();
    }

    @Override
    public void visitInnerClasses_attribute(InnerClasses_attribute attribute) {
        this.indent().append("<inner-classes-attribute>").eol();
        this.raiseIndent();
        for (InnerClass innerClass : attribute.getInnerClasses()) {
            innerClass.accept(this);
        }
        this.lowerIndent();
        this.indent().append("</inner-classes-attribute>").eol();
    }

    @Override
    public void visitSynthetic_attribute(Synthetic_attribute attribute) {
        this.indent().append("<synthetic-attribute/>").eol();
    }

    @Override
    public void visitSourceFile_attribute(SourceFile_attribute attribute) {
        this.indent().append("<source-file-attribute>").append(attribute.getSourceFile()).append("</source-file-attribute>").eol();
    }

    @Override
    public void visitLineNumberTable_attribute(LineNumberTable_attribute attribute) {
        this.indent().append("<line-number-table-attribute>").eol();
        this.raiseIndent();
        for (LineNumber lineNumber : attribute.getLineNumbers()) {
            lineNumber.accept(this);
        }
        this.lowerIndent();
        this.indent().append("</line-number-table-attribute>").eol();
    }

    @Override
    public void visitLocalVariableTable_attribute(LocalVariableTable_attribute attribute) {
        this.indent().append("<local-variable-table-attribute>").eol();
        this.raiseIndent();
        for (LocalVariable localVariable : attribute.getLocalVariables()) {
            localVariable.accept(this);
        }
        this.lowerIndent();
        this.indent().append("</local-variable-table-attribute>").eol();
    }

    @Override
    public void visitDeprecated_attribute(Deprecated_attribute attribute) {
        this.indent().append("<deprecated-attribute/>").eol();
    }

    @Override
    public void visitExceptionHandler(ExceptionHandler helper) {
        this.indent();
        this.append("<exception-handler>");
        this.append("<start-pc>").append(helper.getStartPC()).append("</start-pc>");
        this.append("<end-pc>").append(helper.getEndPC()).append("</end-pc>");
        this.append("<handler-pc>").append(helper.getHandlerPC()).append("</handler-pc>");
        this.append("<catch-type>");
        if (helper.getCatchTypeIndex() != 0) {
            helper.getRawCatchType().accept(this);
        }
        this.append("</catch-type>");
        this.append("</exception-handler>").eol();
    }

    @Override
    public void visitInnerClass(InnerClass helper) {
        this.indent().append("<inner-class access-flag=\"").append(format.format(helper.getAccessFlag())).append("\">").eol();
        this.raiseIndent();
        if (helper.isPublic()) {
            this.indent().append("<public/>").eol();
        }
        if (helper.isProtected()) {
            this.indent().append("<protected/>").eol();
        }
        if (helper.isPrivate()) {
            this.indent().append("<private/>").eol();
        }
        if (helper.isStatic()) {
            this.indent().append("<static/>").eol();
        }
        if (helper.isFinal()) {
            this.indent().append("<final/>").eol();
        }
        if (helper.isInterface()) {
            this.indent().append("<is-interface/>").eol();
        }
        if (helper.isAbstract()) {
            this.indent().append("<abstract/>").eol();
        }
        this.indent();
        this.append("<inner-class-info>");
        if (helper.getInnerClassInfoIndex() != 0) {
            helper.getRawInnerClassInfo().accept(this);
        }
        this.append("</inner-class-info>").eol();
        this.indent();
        this.append("<outer-class-info>");
        if (helper.getOuterClassInfoIndex() != 0) {
            helper.getRawOuterClassInfo().accept(this);
        }
        this.append("</outer-class-info>").eol();
        this.indent();
        this.append("<inner-name>");
        if (helper.getInnerNameIndex() != 0) {
            helper.getRawInnerName().accept(this);
        }
        this.append("</inner-name>").eol();
        this.lowerIndent();
        this.indent().append("</inner-class>").eol();
    }

    @Override
    public void visitLineNumber(LineNumber helper) {
        this.indent();
        this.append("<line-number>");
        this.append("<start-pc>").append(helper.getStartPC()).append("</start-pc>");
        this.append("<line>").append(helper.getLineNumber()).append("</line>");
        this.append("</line-number>").eol();
    }

    @Override
    public void visitLocalVariable(LocalVariable helper) {
        this.indent();
        this.append("<local-variable pc=\"").append(helper.getStartPC()).append("\" length=\"").append(helper.getLength()).append("\">");
        this.append("<name>");
        helper.getRawName().accept(this);
        this.append("</name>");
        this.append("<type>").append(SignatureHelper.getType(helper.getDescriptor())).append("</type>");
        this.append("</local-variable>").eol();
    }

    private String escapeXMLCharacters(String text) {
        String result = text;
        result = perl.substitute("s/&/&amp;/g", result);
        result = perl.substitute("s/</&lt;/g", result);
        result = perl.substitute("s/>/&gt;/g", result);
        return result;
    }
}

