/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Attribute_info;
import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Code_attribute;
import com.jeantessier.classreader.ConstantPool;
import com.jeantessier.classreader.ConstantPoolEntry;
import com.jeantessier.classreader.ConstantValue_attribute;
import com.jeantessier.classreader.Custom_attribute;
import com.jeantessier.classreader.Deprecated_attribute;
import com.jeantessier.classreader.Double_info;
import com.jeantessier.classreader.ExceptionHandler;
import com.jeantessier.classreader.Exceptions_attribute;
import com.jeantessier.classreader.FieldRef_info;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.Float_info;
import com.jeantessier.classreader.InnerClass;
import com.jeantessier.classreader.InnerClasses_attribute;
import com.jeantessier.classreader.Instruction;
import com.jeantessier.classreader.Integer_info;
import com.jeantessier.classreader.InterfaceMethodRef_info;
import com.jeantessier.classreader.LineNumber;
import com.jeantessier.classreader.LineNumberTable_attribute;
import com.jeantessier.classreader.LocalVariable;
import com.jeantessier.classreader.LocalVariableTable_attribute;
import com.jeantessier.classreader.Long_info;
import com.jeantessier.classreader.MethodRef_info;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.classreader.NameAndType_info;
import com.jeantessier.classreader.SourceFile_attribute;
import com.jeantessier.classreader.String_info;
import com.jeantessier.classreader.Synthetic_attribute;
import com.jeantessier.classreader.UTF8_info;
import com.jeantessier.classreader.Visitor;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VisitorBase
implements Visitor {
    private int currentCount;

    protected void resetCount() {
        this.currentCount = 0;
    }

    protected void incrementCount() {
        ++this.currentCount;
    }

    protected int currentCount() {
        return this.currentCount;
    }

    @Override
    public void visitConstantPool(ConstantPool constantPool) {
        for (ConstantPoolEntry entry : constantPool) {
            if (entry != null) {
                entry.accept(this);
            }
            this.incrementCount();
        }
    }

    @Override
    public void visitClassfiles(Collection<Classfile> classfiles) {
        for (Classfile classfile : classfiles) {
            classfile.accept(this);
        }
    }

    @Override
    public void visitClassfile(Classfile classfile) {
        for (Attribute_info attribute : classfile.getAttributes()) {
            attribute.accept(this);
        }
        for (Field_info field : classfile.getAllFields()) {
            field.accept(this);
        }
        for (Method_info method : classfile.getAllMethods()) {
            method.accept(this);
        }
    }

    @Override
    public void visitClass_info(Class_info entry) {
    }

    @Override
    public void visitFieldRef_info(FieldRef_info entry) {
    }

    @Override
    public void visitMethodRef_info(MethodRef_info entry) {
    }

    @Override
    public void visitInterfaceMethodRef_info(InterfaceMethodRef_info entry) {
    }

    @Override
    public void visitString_info(String_info entry) {
    }

    @Override
    public void visitInteger_info(Integer_info entry) {
    }

    @Override
    public void visitFloat_info(Float_info entry) {
    }

    @Override
    public void visitLong_info(Long_info entry) {
    }

    @Override
    public void visitDouble_info(Double_info entry) {
    }

    @Override
    public void visitNameAndType_info(NameAndType_info entry) {
    }

    @Override
    public void visitUTF8_info(UTF8_info entry) {
    }

    @Override
    public void visitField_info(Field_info entry) {
        for (Attribute_info attribute : entry.getAttributes()) {
            attribute.accept(this);
        }
    }

    @Override
    public void visitMethod_info(Method_info entry) {
        for (Attribute_info attribute : entry.getAttributes()) {
            attribute.accept(this);
        }
    }

    @Override
    public void visitConstantValue_attribute(ConstantValue_attribute attribute) {
    }

    @Override
    public void visitCode_attribute(Code_attribute attribute) {
        Logger.getLogger(this.getClass()).debug((Object)"Visiting instruction(s) ...");
        Iterator i = attribute.iterator();
        while (i.hasNext()) {
            ((Instruction)i.next()).accept(this);
        }
        Logger.getLogger(this.getClass()).debug((Object)("Visiting " + attribute.getExceptionHandlers().size() + " exception handler(s) ..."));
        for (ExceptionHandler exceptionHandler : attribute.getExceptionHandlers()) {
            exceptionHandler.accept(this);
        }
        Logger.getLogger(this.getClass()).debug((Object)("Visiting " + attribute.getAttributes().size() + " code attribute(s) ..."));
        for (Attribute_info attribute_info : attribute.getAttributes()) {
            attribute_info.accept(this);
        }
    }

    @Override
    public void visitExceptions_attribute(Exceptions_attribute attribute) {
        Logger.getLogger(this.getClass()).debug((Object)("Visiting " + attribute.getExceptions().size() + " exception class(es) ..."));
        for (Class_info exception : attribute.getExceptions()) {
            exception.accept(this);
        }
    }

    @Override
    public void visitInnerClasses_attribute(InnerClasses_attribute attribute) {
        Logger.getLogger(this.getClass()).debug((Object)("Visiting " + attribute.getInnerClasses().size() + " inner class(es) ..."));
        for (InnerClass innerClass : attribute.getInnerClasses()) {
            innerClass.accept(this);
        }
    }

    @Override
    public void visitSynthetic_attribute(Synthetic_attribute attribute) {
    }

    @Override
    public void visitSourceFile_attribute(SourceFile_attribute attribute) {
    }

    @Override
    public void visitLineNumberTable_attribute(LineNumberTable_attribute attribute) {
        Logger.getLogger(this.getClass()).debug((Object)("Visiting " + attribute.getLineNumbers().size() + " line number(s) ..."));
        for (LineNumber lineNumber : attribute.getLineNumbers()) {
            lineNumber.accept(this);
        }
    }

    @Override
    public void visitLocalVariableTable_attribute(LocalVariableTable_attribute attribute) {
        Logger.getLogger(this.getClass()).debug((Object)("Visiting " + attribute.getLocalVariables().size() + " local variable(s) ..."));
        for (LocalVariable localVariable : attribute.getLocalVariables()) {
            localVariable.accept(this);
        }
    }

    @Override
    public void visitDeprecated_attribute(Deprecated_attribute attribute) {
    }

    @Override
    public void visitCustom_attribute(Custom_attribute attribute) {
    }

    @Override
    public void visitInstruction(Instruction helper) {
    }

    @Override
    public void visitExceptionHandler(ExceptionHandler helper) {
    }

    @Override
    public void visitInnerClass(InnerClass helper) {
    }

    @Override
    public void visitLineNumber(LineNumber helper) {
    }

    @Override
    public void visitLocalVariable(LocalVariable helper) {
    }
}

