/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Double_info;
import com.jeantessier.classreader.FieldRef_info;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.Float_info;
import com.jeantessier.classreader.Integer_info;
import com.jeantessier.classreader.InterfaceMethodRef_info;
import com.jeantessier.classreader.Long_info;
import com.jeantessier.classreader.MethodRef_info;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.classreader.NameAndType_info;
import com.jeantessier.classreader.Printer;
import com.jeantessier.classreader.String_info;
import com.jeantessier.classreader.UTF8_info;
import java.io.PrintWriter;

public class TextPrinter
extends Printer {
    private boolean top = true;

    public TextPrinter(PrintWriter out) {
        super(out);
    }

    public void visitClassfile(Classfile classfile) {
        classfile.getConstantPool().accept(this);
        this.append(classfile.getDeclaration()).append(" {").eol();
        for (Field_info field : classfile.getAllFields()) {
            field.accept(this);
        }
        for (Method_info method : classfile.getAllMethods()) {
            method.accept(this);
        }
        this.append("}").eol();
    }

    public void visitClass_info(Class_info entry) {
        if (this.top) {
            this.top = false;
            this.append(this.currentCount()).append(": ");
            this.append("Class ");
            entry.getRawName().accept(this);
            this.eol();
            this.top = true;
        } else {
            entry.getRawName().accept(this);
        }
    }

    public void visitFieldRef_info(FieldRef_info entry) {
        Class_info c = entry.getRawClass();
        NameAndType_info nat = entry.getRawNameAndType();
        if (this.top) {
            this.top = false;
            this.append(this.currentCount()).append(": ");
            this.append("Field ");
            nat.getRawType().accept(this);
            this.append(" ");
            c.accept(this);
            this.append(".");
            nat.getRawName().accept(this);
            this.eol();
            this.top = true;
        } else {
            nat.getRawType().accept(this);
            this.append(" ");
            c.accept(this);
            this.append(".");
            nat.getRawName().accept(this);
        }
    }

    public void visitMethodRef_info(MethodRef_info entry) {
        Class_info c = entry.getRawClass();
        NameAndType_info nat = entry.getRawNameAndType();
        if (this.top) {
            this.top = false;
            this.append(this.currentCount()).append(": ");
            this.append("Method ");
            c.accept(this);
            this.append(".");
            nat.getRawName().accept(this);
            nat.getRawType().accept(this);
            this.eol();
            this.top = true;
        } else {
            c.accept(this);
            this.append(".");
            nat.getRawName().accept(this);
            nat.getRawType().accept(this);
        }
    }

    public void visitInterfaceMethodRef_info(InterfaceMethodRef_info entry) {
        Class_info c = entry.getRawClass();
        NameAndType_info nat = entry.getRawNameAndType();
        if (this.top) {
            this.top = false;
            this.append(this.currentCount()).append(": ");
            this.append("Interface Method ");
            c.accept(this);
            this.append(".");
            nat.getRawName().accept(this);
            nat.getRawType().accept(this);
            this.eol();
            this.top = true;
        } else {
            c.accept(this);
            this.append(".");
            nat.getRawName().accept(this);
            nat.getRawType().accept(this);
        }
    }

    public void visitString_info(String_info entry) {
        if (this.top) {
            this.top = false;
            this.append(this.currentCount()).append(": String \"");
            entry.getRawValue().accept(this);
            this.append("\"").eol();
            this.top = true;
        } else {
            entry.getRawValue().accept(this);
        }
    }

    public void visitInteger_info(Integer_info entry) {
        if (this.top) {
            this.append(this.currentCount()).append(": Integer ").append(entry.getValue()).eol();
        } else {
            this.append(entry.getValue());
        }
    }

    public void visitFloat_info(Float_info entry) {
        if (this.top) {
            this.append(this.currentCount()).append(": Float ").append(entry.getValue()).eol();
        } else {
            this.append(entry.getValue());
        }
    }

    public void visitLong_info(Long_info entry) {
        if (this.top) {
            this.append(this.currentCount()).append(": Long ").append(entry.getValue()).eol();
        } else {
            this.append(entry.getValue());
        }
    }

    public void visitDouble_info(Double_info entry) {
        if (this.top) {
            this.append(this.currentCount()).append(": Double ").append(entry.getValue()).eol();
        } else {
            this.append(entry.getValue());
        }
    }

    public void visitNameAndType_info(NameAndType_info entry) {
        if (this.top) {
            this.top = false;
            this.append(this.currentCount()).append(": Name and Type ");
            entry.getRawName().accept(this);
            this.append(" ");
            entry.getRawType().accept(this);
            this.eol();
            this.top = true;
        } else {
            entry.getRawName().accept(this);
            this.append(" ");
            entry.getRawType().accept(this);
        }
    }

    public void visitUTF8_info(UTF8_info entry) {
        if (this.top) {
            this.append(this.currentCount()).append(": \"").append(entry.getValue()).append("\"").eol();
        } else {
            this.append(entry.getValue());
        }
    }

    public void visitField_info(Field_info entry) {
        this.append("    ").append(entry.getDeclaration()).append(";").eol();
    }

    public void visitMethod_info(Method_info entry) {
        this.append("    ").append(entry.getDeclaration()).append(";").eol();
    }
}

