/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.CollectorBase;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.LocalVariable;
import com.jeantessier.classreader.Method_info;

public class SymbolGatherer
extends CollectorBase {
    private boolean collectingClassNames = true;
    private boolean collectingFieldNames = true;
    private boolean collectingMethodNames = true;
    private boolean collectingLocalNames = true;
    private Method_info currentMethod = null;

    public boolean isCollectingClassNames() {
        return this.collectingClassNames;
    }

    public void setCollectingClassNames(boolean collectingClassNames) {
        this.collectingClassNames = collectingClassNames;
    }

    public boolean isCollectingFieldNames() {
        return this.collectingFieldNames;
    }

    public void setCollectingFieldNames(boolean collectingFieldNames) {
        this.collectingFieldNames = collectingFieldNames;
    }

    public boolean isCollectingMethodNames() {
        return this.collectingMethodNames;
    }

    public void setCollectingMethodNames(boolean collectingMethodNames) {
        this.collectingMethodNames = collectingMethodNames;
    }

    public boolean isCollectingLocalNames() {
        return this.collectingLocalNames;
    }

    public void setCollectingLocalNames(boolean collectingLocalNames) {
        this.collectingLocalNames = collectingLocalNames;
    }

    public void visitClassfile(Classfile classfile) {
        if (this.isCollectingClassNames()) {
            this.add(classfile.getClassName());
        }
        super.visitClassfile(classfile);
    }

    public void visitField_info(Field_info entry) {
        if (this.isCollectingFieldNames()) {
            this.add(entry.getFullSignature());
        }
        super.visitField_info(entry);
    }

    public void visitMethod_info(Method_info entry) {
        if (this.isCollectingMethodNames()) {
            this.add(entry.getFullSignature());
        }
        Method_info previousMethod = this.currentMethod;
        this.currentMethod = entry;
        super.visitMethod_info(entry);
        this.currentMethod = previousMethod;
    }

    public void visitLocalVariable(LocalVariable helper) {
        if (this.isCollectingLocalNames()) {
            this.add(this.currentMethod.getFullSignature() + ": " + helper.getName());
        }
        super.visitLocalVariable(helper);
    }
}

