/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.ClassfileLoaderDispatcher;
import java.io.File;
import org.apache.log4j.Logger;

public class StrictDispatcher
implements ClassfileLoaderDispatcher {
    public ClassfileLoaderDispatcher.Action dispatch(String filename) {
        ClassfileLoaderDispatcher.Action result;
        if (filename.endsWith(".jar")) {
            result = ClassfileLoaderDispatcher.Action.JAR;
            Logger.getLogger(this.getClass()).debug((Object)("Dispatching \"" + filename + "\": ACTION_JAR"));
        } else if (filename.endsWith(".zip")) {
            result = ClassfileLoaderDispatcher.Action.ZIP;
            Logger.getLogger(this.getClass()).debug((Object)("Dispatching \"" + filename + "\": ACTION_ZIP"));
        } else if (filename.endsWith(".class")) {
            result = ClassfileLoaderDispatcher.Action.CLASS;
            Logger.getLogger(this.getClass()).debug((Object)("Dispatching \"" + filename + "\": ACTION_CLASS"));
        } else if (new File(filename).exists()) {
            result = ClassfileLoaderDispatcher.Action.DIRECTORY;
            Logger.getLogger(this.getClass()).debug((Object)("Dispatching \"" + filename + "\": ACTION_DIRECTORY"));
        } else {
            result = ClassfileLoaderDispatcher.Action.IGNORE;
            Logger.getLogger(this.getClass()).debug((Object)("Dispatching \"" + filename + "\": ACTION_IGNORE"));
        }
        return result;
    }
}

