/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Attribute_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.UTF8_info;
import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class SourceFile_attribute
extends Attribute_info {
    private int sourceFileIndex;

    public SourceFile_attribute(Classfile classfile, Visitable owner, DataInputStream in) throws IOException {
        super(classfile, owner);
        int byteCount = in.readInt();
        Logger.getLogger(this.getClass()).debug((Object)("Attribute length: " + byteCount));
        this.sourceFileIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Source file: " + this.sourceFileIndex + " (" + this.getSourceFile() + ")"));
    }

    public int getSourceFileIndex() {
        return this.sourceFileIndex;
    }

    public UTF8_info getRawSourceFile() {
        return (UTF8_info)this.getClassfile().getConstantPool().get(this.getSourceFileIndex());
    }

    public String getSourceFile() {
        return this.getRawSourceFile().toString();
    }

    public String toString() {
        return "Source file \"" + this.getSourceFile() + "\"";
    }

    public void accept(Visitor visitor) {
        visitor.visitSourceFile_attribute(this);
    }
}

