/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.LoadEvent;
import com.jeantessier.classreader.LoadListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageMapper
implements LoadListener {
    private Map<String, Map<String, Classfile>> map = new HashMap<String, Map<String, Classfile>>();

    public Collection<String> getPackageNames() {
        return this.map.keySet();
    }

    public Map<String, Classfile> getPackage(String packageName) {
        return this.map.get(packageName);
    }

    @Override
    public void beginSession(LoadEvent event) {
    }

    @Override
    public void beginGroup(LoadEvent event) {
    }

    @Override
    public void beginFile(LoadEvent event) {
    }

    @Override
    public void beginClassfile(LoadEvent event) {
    }

    @Override
    public void endClassfile(LoadEvent event) {
        Map<String, Classfile> map;
        Classfile classfile = event.getClassfile();
        String packageName = "";
        int pos = classfile.getClassName().lastIndexOf(".");
        if (pos != -1) {
            packageName = classfile.getClassName().substring(0, pos);
        }
        if ((map = this.map.get(packageName)) == null) {
            map = new HashMap<String, Classfile>();
            this.map.put(packageName, map);
        }
        map.put(classfile.getClassName(), classfile);
    }

    @Override
    public void endFile(LoadEvent event) {
    }

    @Override
    public void endGroup(LoadEvent event) {
    }

    @Override
    public void endSession(LoadEvent event) {
    }
}

