/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.ConstantPool;
import com.jeantessier.classreader.ConstantPoolEntry;
import com.jeantessier.classreader.UTF8_info;
import com.jeantessier.classreader.Visitor;
import java.io.DataInputStream;
import java.io.IOException;

public class NameAndType_info
extends ConstantPoolEntry {
    private int nameIndex;
    private int typeIndex;

    public NameAndType_info(ConstantPool constantPool, DataInputStream in) throws IOException {
        super(constantPool);
        this.nameIndex = in.readUnsignedShort();
        this.typeIndex = in.readUnsignedShort();
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public UTF8_info getRawName() {
        return (UTF8_info)this.getConstantPool().get(this.getNameIndex());
    }

    public String getName() {
        return this.getRawName().toString();
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public UTF8_info getRawType() {
        return (UTF8_info)this.getConstantPool().get(this.getTypeIndex());
    }

    public String getType() {
        return this.getRawType().toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getName()).append(" -> ").append(this.getType());
        return result.toString();
    }

    public int hashCode() {
        return this.getRawName().hashCode() ^ this.getRawType().hashCode();
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (this == object) {
            result = true;
        } else if (object != null && this.getClass().equals(object.getClass())) {
            NameAndType_info other = (NameAndType_info)object;
            result = this.getRawName().equals(other.getRawName()) && this.getRawType().equals(other.getRawType());
        }
        return result;
    }

    public void accept(Visitor visitor) {
        visitor.visitNameAndType_info(this);
    }
}

