/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.LoadEvent;
import com.jeantessier.classreader.LoadListenerVisitorAdapter;
import com.jeantessier.classreader.RemoveVisitor;
import com.jeantessier.classreader.Visitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class Monitor
extends LoadListenerVisitorAdapter {
    private RemoveVisitor removeVisitor;
    private Map fileToClass = new HashMap();
    private boolean closedSession = true;
    Collection previousFiles = new TreeSet();
    Collection currentFiles = new TreeSet();

    public Monitor(Visitor addVisitor, RemoveVisitor removeVisitor) {
        super(addVisitor);
        this.removeVisitor = removeVisitor;
    }

    public boolean isClosedSession() {
        return this.closedSession;
    }

    public void setClosedSession(boolean closedSession) {
        if (!this.closedSession && closedSession) {
            this.closeSession();
        }
        this.closedSession = closedSession;
    }

    public void beginFile(LoadEvent event) {
        Logger.getLogger(this.getClass()).debug((Object)("beginFile(..., " + event.getFilename() + ", ...)"));
        this.currentFiles.add(event.getFilename());
    }

    public void endClassfile(LoadEvent event) {
        Logger.getLogger(this.getClass()).debug((Object)("endClassfile(..., " + event.getFilename() + ", " + event.getClassfile() + ")"));
        if (this.previousFiles.contains(event.getFilename())) {
            Logger.getLogger(this.getClass()).debug((Object)("Removing " + event.getClassfile() + " ..."));
            this.removeVisitor.removeClass(event.getClassfile().getClassName());
        }
        super.endClassfile(event);
        this.fileToClass.put(event.getFilename(), event.getClassfile().getClassName());
    }

    public void endFile(LoadEvent event) {
        Logger.getLogger(this.getClass()).debug((Object)("endFile(..., " + event.getFilename() + ", ...)"));
        this.previousFiles.remove(event.getFilename());
    }

    public void endSession(LoadEvent event) {
        Logger.getLogger(this.getClass()).debug((Object)"endSession(...)");
        if (this.isClosedSession()) {
            this.removeUnreadFiles();
            this.closeSession();
        }
    }

    private void removeUnreadFiles() {
        Iterator i = this.previousFiles.iterator();
        while (i.hasNext()) {
            String classname = (String)this.fileToClass.get(i.next());
            Logger.getLogger(this.getClass()).debug((Object)("Removing " + classname + " ..."));
            this.removeVisitor.removeClass(classname);
        }
    }

    private void closeSession() {
        this.previousFiles = this.currentFiles;
        this.currentFiles = new TreeSet();
    }
}

