/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Custom_attribute;
import com.jeantessier.classreader.Deprecated_attribute;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.InnerClass;
import com.jeantessier.classreader.Instruction;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.classreader.Synthetic_attribute;
import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.VisitorBase;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class MetricsGatherer
extends VisitorBase {
    private Collection classes = new LinkedList();
    private Collection interfaces = new LinkedList();
    private Collection methods = new LinkedList();
    private Collection fields = new LinkedList();
    private Collection syntheticClasses = new LinkedList();
    private Collection syntheticFields = new LinkedList();
    private Collection syntheticMethods = new LinkedList();
    private Collection deprecatedClasses = new LinkedList();
    private Collection deprecatedFields = new LinkedList();
    private Collection deprecatedMethods = new LinkedList();
    private Collection publicClasses = new LinkedList();
    private Collection publicFields = new LinkedList();
    private Collection publicMethods = new LinkedList();
    private Collection publicInnerClasses = new LinkedList();
    private Collection protectedFields = new LinkedList();
    private Collection protectedMethods = new LinkedList();
    private Collection protectedInnerClasses = new LinkedList();
    private Collection privateFields = new LinkedList();
    private Collection privateMethods = new LinkedList();
    private Collection privateInnerClasses = new LinkedList();
    private Collection packageClasses = new LinkedList();
    private Collection packageFields = new LinkedList();
    private Collection packageMethods = new LinkedList();
    private Collection packageInnerClasses = new LinkedList();
    private Collection abstractClasses = new LinkedList();
    private Collection abstractMethods = new LinkedList();
    private Collection abstractInnerClasses = new LinkedList();
    private Collection staticFields = new LinkedList();
    private Collection staticMethods = new LinkedList();
    private Collection staticInnerClasses = new LinkedList();
    private Collection finalClasses = new LinkedList();
    private Collection finalFields = new LinkedList();
    private Collection finalMethods = new LinkedList();
    private Collection finalInnerClasses = new LinkedList();
    private Collection synchronizedMethods = new LinkedList();
    private Collection nativeMethods = new LinkedList();
    private Collection volatileFields = new LinkedList();
    private Collection transientFields = new LinkedList();
    private Collection customAttributes = new LinkedList();
    private long[] instructionCounts = new long[256];

    public Collection getClasses() {
        return this.classes;
    }

    public Collection getInterfaces() {
        return this.interfaces;
    }

    public Collection getMethods() {
        return this.methods;
    }

    public Collection getFields() {
        return this.fields;
    }

    public Collection getSyntheticClasses() {
        return this.syntheticClasses;
    }

    public Collection getSyntheticFields() {
        return this.syntheticFields;
    }

    public Collection getSyntheticMethods() {
        return this.syntheticMethods;
    }

    public Collection getDeprecatedClasses() {
        return this.deprecatedClasses;
    }

    public Collection getDeprecatedFields() {
        return this.deprecatedFields;
    }

    public Collection getDeprecatedMethods() {
        return this.deprecatedMethods;
    }

    public Collection getPublicClasses() {
        return this.publicClasses;
    }

    public Collection getPublicFields() {
        return this.publicFields;
    }

    public Collection getPublicMethods() {
        return this.publicMethods;
    }

    public Collection getPublicInnerClasses() {
        return this.publicInnerClasses;
    }

    public Collection getProtectedFields() {
        return this.protectedFields;
    }

    public Collection getProtectedMethods() {
        return this.protectedMethods;
    }

    public Collection getProtectedInnerClasses() {
        return this.protectedInnerClasses;
    }

    public Collection getPrivateFields() {
        return this.privateFields;
    }

    public Collection getPrivateMethods() {
        return this.privateMethods;
    }

    public Collection getPrivateInnerClasses() {
        return this.privateInnerClasses;
    }

    public Collection getPackageClasses() {
        return this.packageClasses;
    }

    public Collection getPackageFields() {
        return this.packageFields;
    }

    public Collection getPackageMethods() {
        return this.packageMethods;
    }

    public Collection getPackageInnerClasses() {
        return this.packageInnerClasses;
    }

    public Collection getAbstractClasses() {
        return this.abstractClasses;
    }

    public Collection getAbstractMethods() {
        return this.abstractMethods;
    }

    public Collection getAbstractInnerClasses() {
        return this.abstractInnerClasses;
    }

    public Collection getStaticFields() {
        return this.staticFields;
    }

    public Collection getStaticMethods() {
        return this.staticMethods;
    }

    public Collection getStaticInnerClasses() {
        return this.staticInnerClasses;
    }

    public Collection getFinalClasses() {
        return this.finalClasses;
    }

    public Collection getFinalFields() {
        return this.finalFields;
    }

    public Collection getFinalMethods() {
        return this.finalMethods;
    }

    public Collection getFinalInnerClasses() {
        return this.finalInnerClasses;
    }

    public Collection getSynchronizedMethods() {
        return this.synchronizedMethods;
    }

    public Collection getNativeMethods() {
        return this.nativeMethods;
    }

    public Collection getVolatileFields() {
        return this.volatileFields;
    }

    public Collection getTransientFields() {
        return this.transientFields;
    }

    public Collection getCustomAttributes() {
        return this.customAttributes;
    }

    public long[] getInstructionCounts() {
        return this.instructionCounts;
    }

    public void visitClassfile(Classfile classfile) {
        if ((classfile.getAccessFlag() & 1) != 0) {
            this.publicClasses.add(classfile);
        } else {
            this.packageClasses.add(classfile);
        }
        if ((classfile.getAccessFlag() & 0x10) != 0) {
            this.finalClasses.add(classfile);
        }
        if ((classfile.getAccessFlag() & 0x200) != 0) {
            this.interfaces.add(classfile);
        } else {
            this.classes.add(classfile);
        }
        if ((classfile.getAccessFlag() & 0x400) != 0) {
            this.abstractClasses.add(classfile);
        }
        super.visitClassfile(classfile);
    }

    public void visitField_info(Field_info entry) {
        this.fields.add(entry);
        if ((entry.getAccessFlag() & 1) != 0) {
            this.publicFields.add(entry);
        } else if ((entry.getAccessFlag() & 2) != 0) {
            this.privateFields.add(entry);
        } else if ((entry.getAccessFlag() & 4) != 0) {
            this.protectedFields.add(entry);
        } else {
            this.packageFields.add(entry);
        }
        if ((entry.getAccessFlag() & 8) != 0) {
            this.staticFields.add(entry);
        }
        if ((entry.getAccessFlag() & 0x10) != 0) {
            this.finalFields.add(entry);
        }
        if ((entry.getAccessFlag() & 0x40) != 0) {
            this.volatileFields.add(entry);
        }
        if ((entry.getAccessFlag() & 0x80) != 0) {
            this.transientFields.add(entry);
        }
        super.visitField_info(entry);
    }

    public void visitMethod_info(Method_info entry) {
        this.methods.add(entry);
        if ((entry.getAccessFlag() & 1) != 0) {
            this.publicMethods.add(entry);
        } else if ((entry.getAccessFlag() & 2) != 0) {
            this.privateMethods.add(entry);
        } else if ((entry.getAccessFlag() & 4) != 0) {
            this.protectedMethods.add(entry);
        } else {
            this.packageMethods.add(entry);
        }
        if ((entry.getAccessFlag() & 8) != 0) {
            this.staticMethods.add(entry);
        }
        if ((entry.getAccessFlag() & 0x10) != 0) {
            this.finalMethods.add(entry);
        }
        if ((entry.getAccessFlag() & 0x20) != 0) {
            this.synchronizedMethods.add(entry);
        }
        if ((entry.getAccessFlag() & 0x100) != 0) {
            this.nativeMethods.add(entry);
        }
        if ((entry.getAccessFlag() & 0x400) != 0) {
            this.abstractMethods.add(entry);
        }
        super.visitMethod_info(entry);
    }

    public void visitSynthetic_attribute(Synthetic_attribute attribute) {
        Visitable owner = attribute.getOwner();
        if (owner instanceof Classfile) {
            this.syntheticClasses.add(owner);
        } else if (owner instanceof Field_info) {
            this.syntheticFields.add(owner);
        } else if (owner instanceof Method_info) {
            this.syntheticMethods.add(owner);
        } else {
            Logger.getLogger(this.getClass()).warn((Object)("Synthetic attribute on unknown Visitable: " + owner.getClass().getName()));
        }
    }

    public void visitDeprecated_attribute(Deprecated_attribute attribute) {
        Visitable owner = attribute.getOwner();
        if (owner instanceof Classfile) {
            this.deprecatedClasses.add(owner);
        } else if (owner instanceof Field_info) {
            this.deprecatedFields.add(owner);
        } else if (owner instanceof Method_info) {
            this.deprecatedMethods.add(owner);
        } else {
            Logger.getLogger(this.getClass()).warn((Object)("Deprecated attribute on unknown Visitable: " + owner.getClass().getName()));
        }
    }

    public void visitCustom_attribute(Custom_attribute attribute) {
        this.customAttributes.add(attribute);
    }

    public void visitInstruction(Instruction helper) {
        long[] lArray = this.getInstructionCounts();
        int n = helper.getOpcode();
        lArray[n] = lArray[n] + 1L;
        super.visitInstruction(helper);
    }

    public void visitInnerClass(InnerClass helper) {
        if ((helper.getAccessFlag() & 1) != 0) {
            this.publicInnerClasses.add(helper);
        } else if ((helper.getAccessFlag() & 2) != 0) {
            this.privateInnerClasses.add(helper);
        } else if ((helper.getAccessFlag() & 4) != 0) {
            this.protectedInnerClasses.add(helper);
        } else {
            this.packageInnerClasses.add(helper);
        }
        if ((helper.getAccessFlag() & 8) != 0) {
            this.staticInnerClasses.add(helper);
        }
        if ((helper.getAccessFlag() & 0x10) != 0) {
            this.finalInnerClasses.add(helper);
        }
        if ((helper.getAccessFlag() & 0x200) != 0) {
            this.interfaces.add(helper);
        } else {
            this.classes.add(helper);
        }
        if ((helper.getAccessFlag() & 0x400) != 0) {
            this.abstractInnerClasses.add(helper);
        }
    }
}

