/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Attribute_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Code_attribute;
import com.jeantessier.classreader.Exceptions_attribute;
import com.jeantessier.classreader.Feature_info;
import com.jeantessier.classreader.SignatureHelper;
import com.jeantessier.classreader.Visitor;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class Method_info
extends Feature_info {
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_STRICT = 2048;

    public Method_info(Classfile classfile, DataInputStream in) throws IOException {
        super(classfile, in);
    }

    public String getFeatureType() {
        return "method";
    }

    public boolean isSynchronized() {
        return (this.getAccessFlag() & 0x20) != 0;
    }

    public boolean isNative() {
        return (this.getAccessFlag() & 0x100) != 0;
    }

    public boolean isAbstract() {
        return (this.getAccessFlag() & 0x400) != 0;
    }

    public boolean isStrict() {
        return (this.getAccessFlag() & 0x800) != 0;
    }

    public boolean isConstructor() {
        return this.getName().equals("<init>");
    }

    public boolean isStaticInitializer() {
        return this.getName().equals("<clinit>");
    }

    public Collection getExceptions() {
        Collection<Object> result = Collections.emptyList();
        for (Attribute_info attribute : this.getAttributes()) {
            if (!(attribute instanceof Exceptions_attribute)) continue;
            result = ((Exceptions_attribute)attribute).getExceptions();
        }
        return result;
    }

    public String getSignature() {
        StringBuffer result = new StringBuffer();
        if (this.isConstructor()) {
            result.append(this.getClassfile().getSimpleName());
            result.append(SignatureHelper.getSignature(this.getDescriptor()));
        } else if (this.isStaticInitializer()) {
            result.append("static {}");
        } else {
            result.append(this.getName());
            result.append(SignatureHelper.getSignature(this.getDescriptor()));
        }
        return result.toString();
    }

    public String getReturnType() {
        return SignatureHelper.getReturnType(this.getDescriptor());
    }

    public String getDeclaration() {
        StringBuffer result = new StringBuffer();
        if (this.isPublic()) {
            result.append("public ");
        }
        if (this.isProtected()) {
            result.append("protected ");
        }
        if (this.isPrivate()) {
            result.append("private ");
        }
        if (this.isStatic()) {
            result.append("static ");
        }
        if (this.isFinal()) {
            result.append("final ");
        }
        if (this.isSynchronized()) {
            result.append("synchronized ");
        }
        if (this.isNative()) {
            result.append("native ");
        }
        if (this.isAbstract()) {
            result.append("abstract ");
        }
        if (!this.getName().equals("<init>") && !this.getName().equals("<clinit>")) {
            result.append(this.getReturnType() != null ? this.getReturnType() : "void").append(" ");
        }
        result.append(this.getSignature());
        if (this.getExceptions().size() != 0) {
            result.append(" throws ");
            Iterator i = this.getExceptions().iterator();
            while (i.hasNext()) {
                result.append(i.next());
                if (!i.hasNext()) continue;
                result.append(", ");
            }
        }
        return result.toString();
    }

    public Code_attribute getCode() {
        Code_attribute result = null;
        Iterator<Attribute_info> i = this.getAttributes().iterator();
        while (result == null && i.hasNext()) {
            Attribute_info temp = i.next();
            if (!(temp instanceof Code_attribute)) continue;
            result = (Code_attribute)temp;
        }
        return result;
    }

    public void accept(Visitor visitor) {
        visitor.visitMethod_info(this);
    }
}

