/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.ConstantPool;
import com.jeantessier.classreader.FeatureRef_info;
import com.jeantessier.classreader.SignatureHelper;
import com.jeantessier.classreader.Visitor;
import java.io.DataInputStream;
import java.io.IOException;

public class MethodRef_info
extends FeatureRef_info {
    public MethodRef_info(ConstantPool constantPool, DataInputStream in) throws IOException {
        super(constantPool, in);
    }

    public boolean isConstructor() {
        return this.getRawNameAndType().getName().equals("<init>");
    }

    public boolean isStaticInitializer() {
        return this.getRawNameAndType().getName().equals("<clinit>");
    }

    public String getName() {
        String result = null;
        result = this.isConstructor() ? this.getClassSimpleName() : (this.isStaticInitializer() ? "static {}" : this.getRawNameAndType().getName());
        return result;
    }

    public String getSignature() {
        StringBuffer result = new StringBuffer();
        result.append(this.getName());
        if (!this.isStaticInitializer()) {
            result.append(SignatureHelper.getSignature(this.getRawNameAndType().getType()));
        }
        return result.toString();
    }

    public void accept(Visitor visitor) {
        visitor.visitMethodRef_info(this);
    }
}

