/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Attribute_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.LocalVariable;
import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVariableTable_attribute
extends Attribute_info {
    private Collection<LocalVariable> localVariables = new LinkedList<LocalVariable>();

    public LocalVariableTable_attribute(Classfile classfile, Visitable owner, DataInputStream in) throws IOException {
        super(classfile, owner);
        int byteCount = in.readInt();
        Logger.getLogger(this.getClass()).debug((Object)("Attribute length: " + byteCount));
        int localVariableTableLength = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + localVariableTableLength + " local variable(s) ..."));
        for (int i = 0; i < localVariableTableLength; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("Local variable " + i + ":"));
            this.localVariables.add(new LocalVariable(this, in));
        }
    }

    public Collection<LocalVariable> getLocalVariables() {
        return this.localVariables;
    }

    public String toString() {
        return "Local Variable Table";
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLocalVariableTable_attribute(this);
    }
}

