/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.LocalVariableTable_attribute;
import com.jeantessier.classreader.UTF8_info;
import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class LocalVariable
implements Visitable {
    private LocalVariableTable_attribute localVariableTable;
    private int startPC;
    private int length;
    private int nameIndex;
    private int descriptorIndex;
    private int index;

    public LocalVariable(LocalVariableTable_attribute localVariableTable, DataInputStream in) throws IOException {
        this.localVariableTable = localVariableTable;
        this.startPC = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("start PC: " + this.startPC));
        this.length = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("length: " + this.length));
        this.nameIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("name: " + this.nameIndex + " (" + this.getName() + ")"));
        this.descriptorIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("descriptor: " + this.descriptorIndex + " (" + this.getDescriptor() + ")"));
        this.index = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("index: " + this.index));
    }

    public LocalVariableTable_attribute getLocalVariableTable() {
        return this.localVariableTable;
    }

    public int getStartPC() {
        return this.startPC;
    }

    public int getLength() {
        return this.length;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public UTF8_info getRawName() {
        return (UTF8_info)this.getLocalVariableTable().getClassfile().getConstantPool().get(this.getNameIndex());
    }

    public String getName() {
        return this.getRawName().toString();
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public UTF8_info getRawDescriptor() {
        return (UTF8_info)this.getLocalVariableTable().getClassfile().getConstantPool().get(this.getDescriptorIndex());
    }

    public String getDescriptor() {
        return this.getRawDescriptor().toString();
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return "Local variable " + this.getDescriptor() + " " + this.getName();
    }

    public void accept(Visitor visitor) {
        visitor.visitLocalVariable(this);
    }
}

