/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.GroupData;
import com.jeantessier.classreader.LoadEvent;
import com.jeantessier.classreader.LoadListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadListenerBase
implements LoadListener {
    private LinkedList<GroupData> groups = new LinkedList();
    private Collection<String> visitedFiles = new HashSet<String>();

    protected GroupData getCurrentGroup() {
        GroupData result = null;
        if (!this.groups.isEmpty()) {
            result = this.groups.getLast();
        }
        return result;
    }

    protected Collection<String> getVisitedFiles() {
        return this.visitedFiles;
    }

    @Override
    public void beginSession(LoadEvent event) {
    }

    @Override
    public void beginGroup(LoadEvent event) {
        this.groups.add(new GroupData(event.getGroupName(), event.getSize()));
    }

    @Override
    public void beginFile(LoadEvent event) {
        this.getCurrentGroup().incrementCount();
    }

    @Override
    public void beginClassfile(LoadEvent event) {
    }

    @Override
    public void endClassfile(LoadEvent event) {
        this.visitedFiles.add(event.getFilename());
    }

    @Override
    public void endFile(LoadEvent event) {
    }

    @Override
    public void endGroup(LoadEvent event) {
        this.visitedFiles.add(event.getGroupName());
        this.groups.removeLast();
    }

    @Override
    public void endSession(LoadEvent event) {
    }
}

