/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Attribute_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.LineNumber;
import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineNumberTable_attribute
extends Attribute_info {
    private Collection<LineNumber> lineNumbers = new LinkedList<LineNumber>();

    public LineNumberTable_attribute(Classfile classfile, Visitable owner, DataInputStream in) throws IOException {
        super(classfile, owner);
        int byteCount = in.readInt();
        Logger.getLogger(this.getClass()).debug((Object)("Attribute length: " + byteCount));
        int lineNumberTableLength = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + lineNumberTableLength + " line number(s) ..."));
        for (int i = 0; i < lineNumberTableLength; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("Line number entry " + i + ":"));
            this.lineNumbers.add(new LineNumber(this, in));
        }
    }

    public Collection<LineNumber> getLineNumbers() {
        return this.lineNumbers;
    }

    public String toString() {
        return "Line Number Table";
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLineNumberTable_attribute(this);
    }
}

