/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Code_attribute;
import com.jeantessier.classreader.ConstantPoolEntry;
import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;

public class Instruction
implements Visitable {
    private static String[] opcode = new String[256];
    private static int[] length = new int[256];
    private Code_attribute code;
    private byte[] bytecode;
    private int start;

    public Instruction(Code_attribute code, byte[] bytecode, int start) {
        this.code = code;
        this.bytecode = bytecode;
        this.start = start;
    }

    public Code_attribute getCode() {
        return this.code;
    }

    public byte[] getBytecode() {
        return this.bytecode;
    }

    public int getStart() {
        return this.start;
    }

    public int getOpcode() {
        return this.bytecode[this.start] & 0xFF;
    }

    public static String getMnemonic(int instruction) {
        return opcode[instruction];
    }

    public String getMnemonic() {
        String result = Instruction.getMnemonic(this.getOpcode());
        if (this.getOpcode() == 196) {
            result = result + " " + Instruction.getMnemonic(this.bytecode[this.start + 1] & 0xFF);
        }
        return result;
    }

    public int getLength() {
        int result = length[this.getOpcode()];
        switch (this.getOpcode()) {
            case 170: {
                int padding = 3 - this.start % 4;
                int low = (this.bytecode[this.start + padding + 5] & 0xFF) << 24 | (this.bytecode[this.start + padding + 6] & 0xFF) << 16 | (this.bytecode[this.start + padding + 7] & 0xFF) << 8 | this.bytecode[this.start + padding + 8] & 0xFF;
                int high = (this.bytecode[this.start + padding + 9] & 0xFF) << 24 | (this.bytecode[this.start + padding + 10] & 0xFF) << 16 | (this.bytecode[this.start + padding + 11] & 0xFF) << 8 | this.bytecode[this.start + padding + 12] & 0xFF;
                result = 1 + padding + 12 + (high - low + 1) * 4;
                break;
            }
            case 171: {
                int padding = 3 - this.start % 4;
                int npairs = (this.bytecode[this.start + padding + 5] & 0xFF) << 24 | (this.bytecode[this.start + padding + 6] & 0xFF) << 16 | (this.bytecode[this.start + padding + 7] & 0xFF) << 8 | this.bytecode[this.start + padding + 8] & 0xFF;
                result = 1 + padding + 8 + npairs * 8;
                break;
            }
            case 196: {
                if ((this.bytecode[this.start + 1] & 0xFF) == 132) {
                    result = 6;
                    break;
                }
                result = 4;
                break;
            }
        }
        return result;
    }

    public int getIndex() {
        int result;
        switch (this.getOpcode()) {
            case 19: 
            case 20: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 189: 
            case 192: 
            case 193: 
            case 197: {
                result = (this.getBytecode()[this.getStart() + 1] & 0xFF) << 8 | this.getBytecode()[this.getStart() + 2] & 0xFF;
                break;
            }
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 132: 
            case 169: {
                result = this.getBytecode()[this.getStart() + 1] & 0xFF;
                break;
            }
            case 196: {
                result = (this.getBytecode()[this.getStart() + 2] & 0xFF) << 8 | this.getBytecode()[this.getStart() + 3] & 0xFF;
                break;
            }
            default: {
                result = -1;
            }
        }
        return result;
    }

    public ConstantPoolEntry getIndexedConstantPoolEntry() {
        ConstantPoolEntry result;
        switch (this.getOpcode()) {
            case 18: 
            case 19: 
            case 20: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 189: 
            case 192: 
            case 193: 
            case 197: {
                result = (ConstantPoolEntry)this.getCode().getClassfile().getConstantPool().get(this.getIndex());
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public int hashCode() {
        int result = this.getOpcode();
        if (this.getIndexedConstantPoolEntry() != null) {
            result ^= this.getIndexedConstantPoolEntry().hashCode();
        } else {
            for (int i = 1; i < this.getLength(); ++i) {
                result ^= this.bytecode[this.start + i];
            }
        }
        return result;
    }

    public boolean equals(Object object) {
        boolean result;
        if (this == object) {
            result = true;
        } else if (object == null || this.getClass() != object.getClass()) {
            result = false;
        } else {
            ConstantPoolEntry otherEntry;
            Instruction other = (Instruction)object;
            result = this.getOpcode() == other.getOpcode();
            ConstantPoolEntry thisEntry = this.getCode() != null ? this.getIndexedConstantPoolEntry() : null;
            ConstantPoolEntry constantPoolEntry = otherEntry = other.getCode() != null ? other.getIndexedConstantPoolEntry() : null;
            if (result && thisEntry != null && otherEntry != null) {
                result = thisEntry.equals(otherEntry);
            } else {
                for (int i = 1; result && i < this.getLength(); ++i) {
                    result = this.bytecode[this.start + i] == other.bytecode[other.start + i];
                }
            }
        }
        return result;
    }

    public String toString() {
        return this.getMnemonic();
    }

    public void accept(Visitor visitor) {
        visitor.visitInstruction(this);
    }

    static {
        Instruction.opcode[0] = "nop";
        Instruction.length[0] = 1;
        Instruction.opcode[1] = "aconst_null";
        Instruction.length[1] = 1;
        Instruction.opcode[2] = "iconst_m1";
        Instruction.length[2] = 1;
        Instruction.opcode[3] = "iconst_0";
        Instruction.length[3] = 1;
        Instruction.opcode[4] = "iconst_1";
        Instruction.length[4] = 1;
        Instruction.opcode[5] = "iconst_2";
        Instruction.length[5] = 1;
        Instruction.opcode[6] = "iconst_3";
        Instruction.length[6] = 1;
        Instruction.opcode[7] = "iconst_4";
        Instruction.length[7] = 1;
        Instruction.opcode[8] = "iconst_5";
        Instruction.length[8] = 1;
        Instruction.opcode[9] = "lconst_0";
        Instruction.length[9] = 1;
        Instruction.opcode[10] = "lconst_1";
        Instruction.length[10] = 1;
        Instruction.opcode[11] = "fconst_0";
        Instruction.length[11] = 1;
        Instruction.opcode[12] = "fconst_1";
        Instruction.length[12] = 1;
        Instruction.opcode[13] = "fconst_2";
        Instruction.length[13] = 1;
        Instruction.opcode[14] = "dconst_0";
        Instruction.length[14] = 1;
        Instruction.opcode[15] = "dconst_1";
        Instruction.length[15] = 1;
        Instruction.opcode[16] = "bipush";
        Instruction.length[16] = 2;
        Instruction.opcode[17] = "sipush";
        Instruction.length[17] = 3;
        Instruction.opcode[18] = "ldc";
        Instruction.length[18] = 2;
        Instruction.opcode[19] = "ldc_w";
        Instruction.length[19] = 3;
        Instruction.opcode[20] = "ldc2_w";
        Instruction.length[20] = 3;
        Instruction.opcode[21] = "iload";
        Instruction.length[21] = 2;
        Instruction.opcode[22] = "lload";
        Instruction.length[22] = 2;
        Instruction.opcode[23] = "fload";
        Instruction.length[23] = 2;
        Instruction.opcode[24] = "dload";
        Instruction.length[24] = 2;
        Instruction.opcode[25] = "aload";
        Instruction.length[25] = 2;
        Instruction.opcode[26] = "iload_0";
        Instruction.length[26] = 1;
        Instruction.opcode[27] = "iload_1";
        Instruction.length[27] = 1;
        Instruction.opcode[28] = "iload_2";
        Instruction.length[28] = 1;
        Instruction.opcode[29] = "iload_3";
        Instruction.length[29] = 1;
        Instruction.opcode[30] = "lload_0";
        Instruction.length[30] = 1;
        Instruction.opcode[31] = "lload_1";
        Instruction.length[31] = 1;
        Instruction.opcode[32] = "lload_2";
        Instruction.length[32] = 1;
        Instruction.opcode[33] = "lload_3";
        Instruction.length[33] = 1;
        Instruction.opcode[34] = "fload_0";
        Instruction.length[34] = 1;
        Instruction.opcode[35] = "fload_1";
        Instruction.length[35] = 1;
        Instruction.opcode[36] = "fload_2";
        Instruction.length[36] = 1;
        Instruction.opcode[37] = "fload_3";
        Instruction.length[37] = 1;
        Instruction.opcode[38] = "dload_0";
        Instruction.length[38] = 1;
        Instruction.opcode[39] = "dload_1";
        Instruction.length[39] = 1;
        Instruction.opcode[40] = "dload_2";
        Instruction.length[40] = 1;
        Instruction.opcode[41] = "dload_3";
        Instruction.length[41] = 1;
        Instruction.opcode[42] = "aload_0";
        Instruction.length[42] = 1;
        Instruction.opcode[43] = "aload_1";
        Instruction.length[43] = 1;
        Instruction.opcode[44] = "aload_2";
        Instruction.length[44] = 1;
        Instruction.opcode[45] = "aload_3";
        Instruction.length[45] = 1;
        Instruction.opcode[46] = "iaload";
        Instruction.length[46] = 1;
        Instruction.opcode[47] = "laload";
        Instruction.length[47] = 1;
        Instruction.opcode[48] = "faload";
        Instruction.length[48] = 1;
        Instruction.opcode[49] = "daload";
        Instruction.length[49] = 1;
        Instruction.opcode[50] = "aaload";
        Instruction.length[50] = 1;
        Instruction.opcode[51] = "baload";
        Instruction.length[51] = 1;
        Instruction.opcode[52] = "caload";
        Instruction.length[52] = 1;
        Instruction.opcode[53] = "saload";
        Instruction.length[53] = 1;
        Instruction.opcode[54] = "istore";
        Instruction.length[54] = 2;
        Instruction.opcode[55] = "lstore";
        Instruction.length[55] = 2;
        Instruction.opcode[56] = "fstore";
        Instruction.length[56] = 2;
        Instruction.opcode[57] = "dstore";
        Instruction.length[57] = 2;
        Instruction.opcode[58] = "astore";
        Instruction.length[58] = 2;
        Instruction.opcode[59] = "istore_0";
        Instruction.length[59] = 1;
        Instruction.opcode[60] = "istore_1";
        Instruction.length[60] = 1;
        Instruction.opcode[61] = "istore_2";
        Instruction.length[61] = 1;
        Instruction.opcode[62] = "istore_3";
        Instruction.length[62] = 1;
        Instruction.opcode[63] = "lstore_0";
        Instruction.length[63] = 1;
        Instruction.opcode[64] = "lstore_1";
        Instruction.length[64] = 1;
        Instruction.opcode[65] = "lstore_2";
        Instruction.length[65] = 1;
        Instruction.opcode[66] = "lstore_3";
        Instruction.length[66] = 1;
        Instruction.opcode[67] = "fstore_0";
        Instruction.length[67] = 1;
        Instruction.opcode[68] = "fstore_1";
        Instruction.length[68] = 1;
        Instruction.opcode[69] = "fstore_2";
        Instruction.length[69] = 1;
        Instruction.opcode[70] = "fstore_3";
        Instruction.length[70] = 1;
        Instruction.opcode[71] = "dstore_0";
        Instruction.length[71] = 1;
        Instruction.opcode[72] = "dstore_1";
        Instruction.length[72] = 1;
        Instruction.opcode[73] = "dstore_2";
        Instruction.length[73] = 1;
        Instruction.opcode[74] = "dstore_3";
        Instruction.length[74] = 1;
        Instruction.opcode[75] = "astore_0";
        Instruction.length[75] = 1;
        Instruction.opcode[76] = "astore_1";
        Instruction.length[76] = 1;
        Instruction.opcode[77] = "astore_2";
        Instruction.length[77] = 1;
        Instruction.opcode[78] = "astore_3";
        Instruction.length[78] = 1;
        Instruction.opcode[79] = "iastore";
        Instruction.length[79] = 1;
        Instruction.opcode[80] = "lastore";
        Instruction.length[80] = 1;
        Instruction.opcode[81] = "fastore";
        Instruction.length[81] = 1;
        Instruction.opcode[82] = "dastore";
        Instruction.length[82] = 1;
        Instruction.opcode[83] = "aastore";
        Instruction.length[83] = 1;
        Instruction.opcode[84] = "bastore";
        Instruction.length[84] = 1;
        Instruction.opcode[85] = "castore";
        Instruction.length[85] = 1;
        Instruction.opcode[86] = "sastore";
        Instruction.length[86] = 1;
        Instruction.opcode[87] = "pop";
        Instruction.length[87] = 1;
        Instruction.opcode[88] = "pop2";
        Instruction.length[88] = 1;
        Instruction.opcode[89] = "dup";
        Instruction.length[89] = 1;
        Instruction.opcode[90] = "dup_x1";
        Instruction.length[90] = 1;
        Instruction.opcode[91] = "dup_x2";
        Instruction.length[91] = 1;
        Instruction.opcode[92] = "dup2";
        Instruction.length[92] = 1;
        Instruction.opcode[93] = "dup2_x1";
        Instruction.length[93] = 1;
        Instruction.opcode[94] = "dup2_x2";
        Instruction.length[94] = 1;
        Instruction.opcode[95] = "swap";
        Instruction.length[95] = 1;
        Instruction.opcode[96] = "iadd";
        Instruction.length[96] = 1;
        Instruction.opcode[97] = "ladd";
        Instruction.length[97] = 1;
        Instruction.opcode[98] = "fadd";
        Instruction.length[98] = 1;
        Instruction.opcode[99] = "dadd";
        Instruction.length[99] = 1;
        Instruction.opcode[100] = "isub";
        Instruction.length[100] = 1;
        Instruction.opcode[101] = "lsub";
        Instruction.length[101] = 1;
        Instruction.opcode[102] = "fsub";
        Instruction.length[102] = 1;
        Instruction.opcode[103] = "dsub";
        Instruction.length[103] = 1;
        Instruction.opcode[104] = "imul";
        Instruction.length[104] = 1;
        Instruction.opcode[105] = "lmul";
        Instruction.length[105] = 1;
        Instruction.opcode[106] = "fmul";
        Instruction.length[106] = 1;
        Instruction.opcode[107] = "dmul";
        Instruction.length[107] = 1;
        Instruction.opcode[108] = "idiv";
        Instruction.length[108] = 1;
        Instruction.opcode[109] = "ldiv";
        Instruction.length[109] = 1;
        Instruction.opcode[110] = "fdiv";
        Instruction.length[110] = 1;
        Instruction.opcode[111] = "ddiv";
        Instruction.length[111] = 1;
        Instruction.opcode[112] = "irem";
        Instruction.length[112] = 1;
        Instruction.opcode[113] = "lrem";
        Instruction.length[113] = 1;
        Instruction.opcode[114] = "frem";
        Instruction.length[114] = 1;
        Instruction.opcode[115] = "drem";
        Instruction.length[115] = 1;
        Instruction.opcode[116] = "ineg";
        Instruction.length[116] = 1;
        Instruction.opcode[117] = "lneg";
        Instruction.length[117] = 1;
        Instruction.opcode[118] = "fneg";
        Instruction.length[118] = 1;
        Instruction.opcode[119] = "dneg";
        Instruction.length[119] = 1;
        Instruction.opcode[120] = "ishl";
        Instruction.length[120] = 1;
        Instruction.opcode[121] = "lshl";
        Instruction.length[121] = 1;
        Instruction.opcode[122] = "ishr";
        Instruction.length[122] = 1;
        Instruction.opcode[123] = "lshr";
        Instruction.length[123] = 1;
        Instruction.opcode[124] = "iushr";
        Instruction.length[124] = 1;
        Instruction.opcode[125] = "lushr";
        Instruction.length[125] = 1;
        Instruction.opcode[126] = "iand";
        Instruction.length[126] = 1;
        Instruction.opcode[127] = "land";
        Instruction.length[127] = 1;
        Instruction.opcode[128] = "ior";
        Instruction.length[128] = 1;
        Instruction.opcode[129] = "lor";
        Instruction.length[129] = 1;
        Instruction.opcode[130] = "ixor";
        Instruction.length[130] = 1;
        Instruction.opcode[131] = "lxor";
        Instruction.length[131] = 1;
        Instruction.opcode[132] = "iinc";
        Instruction.length[132] = 3;
        Instruction.opcode[133] = "i2l";
        Instruction.length[133] = 1;
        Instruction.opcode[134] = "i2f";
        Instruction.length[134] = 1;
        Instruction.opcode[135] = "i2d";
        Instruction.length[135] = 1;
        Instruction.opcode[136] = "l2i";
        Instruction.length[136] = 1;
        Instruction.opcode[137] = "l2f";
        Instruction.length[137] = 1;
        Instruction.opcode[138] = "l2d";
        Instruction.length[138] = 1;
        Instruction.opcode[139] = "f2i";
        Instruction.length[139] = 1;
        Instruction.opcode[140] = "f2l";
        Instruction.length[140] = 1;
        Instruction.opcode[141] = "f2d";
        Instruction.length[141] = 1;
        Instruction.opcode[142] = "d2i";
        Instruction.length[142] = 1;
        Instruction.opcode[143] = "d2l";
        Instruction.length[143] = 1;
        Instruction.opcode[144] = "d2f";
        Instruction.length[144] = 1;
        Instruction.opcode[145] = "i2b";
        Instruction.length[145] = 1;
        Instruction.opcode[146] = "i2c";
        Instruction.length[146] = 1;
        Instruction.opcode[147] = "i2s";
        Instruction.length[147] = 1;
        Instruction.opcode[148] = "lcmp";
        Instruction.length[148] = 1;
        Instruction.opcode[149] = "fcmpl";
        Instruction.length[149] = 1;
        Instruction.opcode[150] = "fcmpg";
        Instruction.length[150] = 1;
        Instruction.opcode[151] = "dcmpl";
        Instruction.length[151] = 1;
        Instruction.opcode[152] = "dcmpg";
        Instruction.length[152] = 1;
        Instruction.opcode[153] = "ifeq";
        Instruction.length[153] = 3;
        Instruction.opcode[154] = "ifne";
        Instruction.length[154] = 3;
        Instruction.opcode[155] = "iflt";
        Instruction.length[155] = 3;
        Instruction.opcode[156] = "ifge";
        Instruction.length[156] = 3;
        Instruction.opcode[157] = "ifgt";
        Instruction.length[157] = 3;
        Instruction.opcode[158] = "ifle";
        Instruction.length[158] = 3;
        Instruction.opcode[159] = "if_icmpeq";
        Instruction.length[159] = 3;
        Instruction.opcode[160] = "if_icmpne";
        Instruction.length[160] = 3;
        Instruction.opcode[161] = "if_icmplt";
        Instruction.length[161] = 3;
        Instruction.opcode[162] = "if_icmpge";
        Instruction.length[162] = 3;
        Instruction.opcode[163] = "if_icmpgt";
        Instruction.length[163] = 3;
        Instruction.opcode[164] = "if_icmple";
        Instruction.length[164] = 3;
        Instruction.opcode[165] = "if_acmpeq";
        Instruction.length[165] = 3;
        Instruction.opcode[166] = "if_acmpne";
        Instruction.length[166] = 3;
        Instruction.opcode[167] = "goto";
        Instruction.length[167] = 3;
        Instruction.opcode[168] = "jsr";
        Instruction.length[168] = 3;
        Instruction.opcode[169] = "ret";
        Instruction.length[169] = 2;
        Instruction.opcode[170] = "tableswitch";
        Instruction.length[170] = -1;
        Instruction.opcode[171] = "lookupswitch";
        Instruction.length[171] = -1;
        Instruction.opcode[172] = "ireturn";
        Instruction.length[172] = 1;
        Instruction.opcode[173] = "lreturn";
        Instruction.length[173] = 1;
        Instruction.opcode[174] = "freturn";
        Instruction.length[174] = 1;
        Instruction.opcode[175] = "dreturn";
        Instruction.length[175] = 1;
        Instruction.opcode[176] = "areturn";
        Instruction.length[176] = 1;
        Instruction.opcode[177] = "return";
        Instruction.length[177] = 1;
        Instruction.opcode[178] = "getstatic";
        Instruction.length[178] = 3;
        Instruction.opcode[179] = "putstatic";
        Instruction.length[179] = 3;
        Instruction.opcode[180] = "getfield";
        Instruction.length[180] = 3;
        Instruction.opcode[181] = "putfield";
        Instruction.length[181] = 3;
        Instruction.opcode[182] = "invokevirtual";
        Instruction.length[182] = 3;
        Instruction.opcode[183] = "invokespecial";
        Instruction.length[183] = 3;
        Instruction.opcode[184] = "invokestatic";
        Instruction.length[184] = 3;
        Instruction.opcode[185] = "invokeinterface";
        Instruction.length[185] = 5;
        Instruction.opcode[186] = "invokedynamic";
        Instruction.length[186] = 3;
        Instruction.opcode[187] = "new";
        Instruction.length[187] = 3;
        Instruction.opcode[188] = "newarray";
        Instruction.length[188] = 2;
        Instruction.opcode[189] = "anewarray";
        Instruction.length[189] = 3;
        Instruction.opcode[190] = "arraylength";
        Instruction.length[190] = 1;
        Instruction.opcode[191] = "athrow";
        Instruction.length[191] = 1;
        Instruction.opcode[192] = "checkcast";
        Instruction.length[192] = 3;
        Instruction.opcode[193] = "instanceof";
        Instruction.length[193] = 3;
        Instruction.opcode[194] = "monitorenter";
        Instruction.length[194] = 1;
        Instruction.opcode[195] = "monitorexit";
        Instruction.length[195] = 1;
        Instruction.opcode[196] = "wide";
        Instruction.length[196] = -1;
        Instruction.opcode[197] = "multianewarray";
        Instruction.length[197] = 4;
        Instruction.opcode[198] = "ifnull";
        Instruction.length[198] = 3;
        Instruction.opcode[199] = "ifnonnull";
        Instruction.length[199] = 3;
        Instruction.opcode[200] = "goto_w";
        Instruction.length[200] = 5;
        Instruction.opcode[201] = "jsr_w";
        Instruction.length[201] = 5;
        Instruction.opcode[202] = "breakpoint";
        Instruction.length[202] = 1;
        Instruction.opcode[203] = "xxxundefinedxxx";
        Instruction.length[203] = 1;
        Instruction.opcode[204] = "xxxundefinedxxx";
        Instruction.length[204] = 1;
        Instruction.opcode[205] = "xxxundefinedxxx";
        Instruction.length[205] = 1;
        Instruction.opcode[206] = "xxxundefinedxxx";
        Instruction.length[206] = 1;
        Instruction.opcode[207] = "xxxundefinedxxx";
        Instruction.length[207] = 1;
        Instruction.opcode[208] = "xxxundefinedxxx";
        Instruction.length[208] = 1;
        Instruction.opcode[209] = "xxxundefinedxxx";
        Instruction.length[209] = 1;
        Instruction.opcode[210] = "xxxundefinedxxx";
        Instruction.length[210] = 1;
        Instruction.opcode[211] = "xxxundefinedxxx";
        Instruction.length[211] = 1;
        Instruction.opcode[212] = "xxxundefinedxxx";
        Instruction.length[212] = 1;
        Instruction.opcode[213] = "xxxundefinedxxx";
        Instruction.length[213] = 1;
        Instruction.opcode[214] = "xxxundefinedxxx";
        Instruction.length[214] = 1;
        Instruction.opcode[215] = "xxxundefinedxxx";
        Instruction.length[215] = 1;
        Instruction.opcode[216] = "xxxundefinedxxx";
        Instruction.length[216] = 1;
        Instruction.opcode[217] = "xxxundefinedxxx";
        Instruction.length[217] = 1;
        Instruction.opcode[218] = "xxxundefinedxxx";
        Instruction.length[218] = 1;
        Instruction.opcode[219] = "xxxundefinedxxx";
        Instruction.length[219] = 1;
        Instruction.opcode[220] = "xxxundefinedxxx";
        Instruction.length[220] = 1;
        Instruction.opcode[221] = "xxxundefinedxxx";
        Instruction.length[221] = 1;
        Instruction.opcode[222] = "xxxundefinedxxx";
        Instruction.length[222] = 1;
        Instruction.opcode[223] = "xxxundefinedxxx";
        Instruction.length[223] = 1;
        Instruction.opcode[224] = "xxxundefinedxxx";
        Instruction.length[224] = 1;
        Instruction.opcode[225] = "xxxundefinedxxx";
        Instruction.length[225] = 1;
        Instruction.opcode[226] = "xxxundefinedxxx";
        Instruction.length[226] = 1;
        Instruction.opcode[227] = "xxxundefinedxxx";
        Instruction.length[227] = 1;
        Instruction.opcode[228] = "xxxundefinedxxx";
        Instruction.length[228] = 1;
        Instruction.opcode[229] = "xxxundefinedxxx";
        Instruction.length[229] = 1;
        Instruction.opcode[230] = "xxxundefinedxxx";
        Instruction.length[230] = 1;
        Instruction.opcode[231] = "xxxundefinedxxx";
        Instruction.length[231] = 1;
        Instruction.opcode[232] = "xxxundefinedxxx";
        Instruction.length[232] = 1;
        Instruction.opcode[233] = "xxxundefinedxxx";
        Instruction.length[233] = 1;
        Instruction.opcode[234] = "xxxundefinedxxx";
        Instruction.length[234] = 1;
        Instruction.opcode[235] = "xxxundefinedxxx";
        Instruction.length[235] = 1;
        Instruction.opcode[236] = "xxxundefinedxxx";
        Instruction.length[236] = 1;
        Instruction.opcode[237] = "xxxundefinedxxx";
        Instruction.length[237] = 1;
        Instruction.opcode[238] = "xxxundefinedxxx";
        Instruction.length[238] = 1;
        Instruction.opcode[239] = "xxxundefinedxxx";
        Instruction.length[239] = 1;
        Instruction.opcode[240] = "xxxundefinedxxx";
        Instruction.length[240] = 1;
        Instruction.opcode[241] = "xxxundefinedxxx";
        Instruction.length[241] = 1;
        Instruction.opcode[242] = "xxxundefinedxxx";
        Instruction.length[242] = 1;
        Instruction.opcode[243] = "xxxundefinedxxx";
        Instruction.length[243] = 1;
        Instruction.opcode[244] = "xxxundefinedxxx";
        Instruction.length[244] = 1;
        Instruction.opcode[245] = "xxxundefinedxxx";
        Instruction.length[245] = 1;
        Instruction.opcode[246] = "xxxundefinedxxx";
        Instruction.length[246] = 1;
        Instruction.opcode[247] = "xxxundefinedxxx";
        Instruction.length[247] = 1;
        Instruction.opcode[248] = "xxxundefinedxxx";
        Instruction.length[248] = 1;
        Instruction.opcode[249] = "xxxundefinedxxx";
        Instruction.length[249] = 1;
        Instruction.opcode[250] = "xxxundefinedxxx";
        Instruction.length[250] = 1;
        Instruction.opcode[251] = "xxxundefinedxxx";
        Instruction.length[251] = 1;
        Instruction.opcode[252] = "xxxundefinedxxx";
        Instruction.length[252] = 1;
        Instruction.opcode[253] = "xxxundefinedxxx";
        Instruction.length[253] = 1;
        Instruction.opcode[254] = "impdep1";
        Instruction.length[254] = 1;
        Instruction.opcode[255] = "impdep2";
        Instruction.length[255] = 1;
    }
}

