/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Attribute_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.InnerClass;
import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InnerClasses_attribute
extends Attribute_info {
    private Collection<InnerClass> classes = new LinkedList<InnerClass>();

    public InnerClasses_attribute(Classfile classfile, Visitable owner, DataInputStream in) throws IOException {
        super(classfile, owner);
        int byteCount = in.readInt();
        Logger.getLogger(this.getClass()).debug((Object)("Attribute length: " + byteCount));
        int classCount = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + classCount + " inner class(es) ..."));
        for (int i = 0; i < classCount; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("Inner class " + i + ":"));
            this.classes.add(new InnerClass(this, in));
        }
    }

    public Collection<InnerClass> getInnerClasses() {
        return this.classes;
    }

    public String toString() {
        return "InnerClasses";
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitInnerClasses_attribute(this);
    }
}

