/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.InnerClasses_attribute;
import com.jeantessier.classreader.UTF8_info;
import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class InnerClass
implements Visitable {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    private InnerClasses_attribute innerClasses;
    private int innerClassInfoIndex;
    private int outerClassInfoIndex;
    private int innerNameIndex;
    private int accessFlag;

    public InnerClass(InnerClasses_attribute innerClasses, DataInputStream in) throws IOException {
        this.innerClasses = innerClasses;
        this.innerClassInfoIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Inner class info index: " + this.innerClassInfoIndex + " (" + this.getInnerClassInfo() + ")"));
        this.outerClassInfoIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Outer class info index: " + this.outerClassInfoIndex + " (" + this.getOuterClassInfo() + ")"));
        this.innerNameIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Inner name index: " + this.innerNameIndex + " (" + this.getInnerName() + ")"));
        this.accessFlag = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Inner class access flag: " + this.accessFlag));
    }

    public InnerClasses_attribute getInnerClasses() {
        return this.innerClasses;
    }

    public int getInnerClassInfoIndex() {
        return this.innerClassInfoIndex;
    }

    public Class_info getRawInnerClassInfo() {
        return (Class_info)this.innerClasses.getClassfile().getConstantPool().get(this.getInnerClassInfoIndex());
    }

    public String getInnerClassInfo() {
        String result = "";
        if (this.getInnerClassInfoIndex() != 0) {
            result = this.getRawInnerClassInfo().toString();
        }
        return result;
    }

    public int getOuterClassInfoIndex() {
        return this.outerClassInfoIndex;
    }

    public Class_info getRawOuterClassInfo() {
        return (Class_info)this.innerClasses.getClassfile().getConstantPool().get(this.getOuterClassInfoIndex());
    }

    public String getOuterClassInfo() {
        String result = "";
        if (this.getOuterClassInfoIndex() != 0) {
            result = this.getRawOuterClassInfo().toString();
        }
        return result;
    }

    public int getInnerNameIndex() {
        return this.innerNameIndex;
    }

    public UTF8_info getRawInnerName() {
        return (UTF8_info)this.innerClasses.getClassfile().getConstantPool().get(this.getInnerNameIndex());
    }

    public String getInnerName() {
        String result = "";
        if (this.getInnerNameIndex() != 0) {
            result = this.getRawInnerName().toString();
        }
        return result;
    }

    public int getAccessFlag() {
        return this.accessFlag;
    }

    public boolean isPublic() {
        return (this.getAccessFlag() & 1) != 0;
    }

    public boolean isProtected() {
        return (this.getAccessFlag() & 4) != 0;
    }

    public boolean isPrivate() {
        return (this.getAccessFlag() & 2) != 0;
    }

    public boolean isPackage() {
        return (this.getAccessFlag() & 7) == 0;
    }

    public boolean isStatic() {
        return (this.getAccessFlag() & 8) != 0;
    }

    public boolean isFinal() {
        return (this.getAccessFlag() & 0x10) != 0;
    }

    public boolean isInterface() {
        return (this.getAccessFlag() & 0x200) != 0;
    }

    public boolean isAbstract() {
        return (this.getAccessFlag() & 0x400) != 0;
    }

    public String toString() {
        return this.getInnerClassInfo();
    }

    public void accept(Visitor visitor) {
        visitor.visitInnerClass(this);
    }
}

