/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.Attribute_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.ConstantValue_attribute;
import com.jeantessier.classreader.Feature_info;
import com.jeantessier.classreader.SignatureHelper;
import com.jeantessier.classreader.String_info;
import com.jeantessier.classreader.Visitor;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Iterator;

public class Field_info
extends Feature_info {
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_TRANSIENT = 128;

    public Field_info(Classfile classfile, DataInputStream in) throws IOException {
        super(classfile, in);
    }

    public String getFeatureType() {
        return "field";
    }

    public boolean isVolatile() {
        return (this.getAccessFlag() & 0x40) != 0;
    }

    public boolean isTransient() {
        return (this.getAccessFlag() & 0x80) != 0;
    }

    public String getType() {
        return SignatureHelper.getType(this.getDescriptor());
    }

    public String getDeclaration() {
        StringBuffer result = new StringBuffer();
        if (this.isPublic()) {
            result.append("public ");
        }
        if (this.isProtected()) {
            result.append("protected ");
        }
        if (this.isPrivate()) {
            result.append("private ");
        }
        if (this.isStatic()) {
            result.append("static ");
        }
        if (this.isFinal()) {
            result.append("final ");
        }
        if (this.isVolatile()) {
            result.append("volatile ");
        }
        if (this.isTransient()) {
            result.append("transient ");
        }
        result.append(this.getType()).append(" ");
        result.append(this.getName());
        return result.toString();
    }

    public String getFullDeclaration() {
        String result = this.getDeclaration();
        if (this.getConstantValue() != null) {
            result = this.getConstantValue().getRawValue() instanceof String_info ? result + " = \"" + this.getConstantValue().getRawValue() + "\"" : result + " = " + this.getConstantValue().getRawValue();
        }
        return result;
    }

    public String getSignature() {
        return this.getName();
    }

    public ConstantValue_attribute getConstantValue() {
        ConstantValue_attribute result = null;
        Iterator<Attribute_info> i = this.getAttributes().iterator();
        while (result == null && i.hasNext()) {
            Attribute_info temp = i.next();
            if (!(temp instanceof ConstantValue_attribute)) continue;
            result = (ConstantValue_attribute)temp;
        }
        return result;
    }

    public void accept(Visitor visitor) {
        visitor.visitField_info(this);
    }
}

